#include <stdio.h>
#include <unistd.h>
#include <bastard.h>

/* To compile:
 * gcc -I/usr/local/bastard/include -L/usr/local/bastard/lib -lbastard dis.c 
 */
int print_disasm_header(struct DISASM_TGT *target) {
	printf(";\t Disassembly of target %s\n", target->info.name );
	printf(";\t\tproduced by the bastard disassembler\n");
	printf("\n\n; HEADER\n%s\n; END HEADER\n\n", target->info.header);
	return(1);
}
int print_disasm_footer(struct DISASM_TGT *target) {
	printf(";\t End of disassembly for %s\n", target->info.name );
	return(1);
}

void print_sec_addr( struct address *a, void *data) {
	addr_print( a->rva );
	return;
}

void print_section( struct section *s, void *data) {
	printf(";\t--------------------------------------------------------\n");
	printf(";\tSECTION\t%s\n", s->name);
	printf(";\t\tStart Address: %08X End Address: %08X\n",
			s->rva, s->rva + s->size );
	printf(";\t--------------------------------------------------------\n\n");
	
	sec_foreach_addr( s, (BAPI_CALLBACK)print_sec_addr, data );

	printf("\n\n");
	return;
}

int main (int argc, char **argv) {
	char base[PATH_MAX];
	struct DISASM_TGT *target;

	/* init bastard */
	if (!sys_find_base(base, PATH_MAX, argv))
		return (-1);

	sys_init(base);
	target = env_get_target();
	env_set_option( "DONT_SAVE" );
	env_set_option( "QUIET" );

      if ( argc < 2 )
		target_load( "a.out");
      else
		target_load(argv[1]);
	

	target_set_ext( "ELF", "i386", "gcc", "linux",
				"C", "intel" );

	/* apply file header first */
	target_apply_format();
	/* disassemble target */
	disasm_target( "full", NULL );

	/* print disassembled listing */
	print_disasm_header(target);
	sec_foreach( (BAPI_CALLBACK)print_section, NULL );
	print_disasm_footer(target);

	/* close bastard */
	target_close_db();
	sys_quit();

	return(0);
}
