#!/usr/bin/perl

# usage:
# ls -1t /usr/include/bits/*.h > gcc.files
# ls -1t /usr/include/*.h >> gcc.files
# vi gcc.files (remove irrelevant header files */
# ./c_hdr.pl gcc.files >> gcc.out
# ls -1t /usr/include/asm/*.h > linux.files
# ls -1t /usr/include/sys/*.h >> linux.files
# vi linux.files (remove irrelevant header files */
# ./c_hdr.pl linux.files >> linux.out

my %c_const, %c_proto, %c_type;
# We have to really hack this for GCC's shitty include files
my $CNAME = q{[A-Za-z_][A-Za-z_0-9]*};
my $CTYPE = qq{$CNAME(?:\\s\\*)?};

open( FILELIST, shift());
foreach ( <FILELIST> ) {
	open( HFILE, $_ );
	@lines = <HFILE>;
	close( HFILE );

	for ( $x = 0; $x < $#lines; $x++ ) {
		$_ = $lines[$x];
		chomp;
		if (/^\s*typedef\s+((?:$CTYPE\s+)+)($CNAME);/) {
			$c_type{$2} = $1;
		} elsif (/^\s*#\s*define\s+(.*)/) {
			if ( $1 =~ /($CNAME)\s*\(\s*[A-Za-z0-9_, ]+\s*\)(.*)/ ) {
				#ignore #print "macro $1: $2\n";
			} elsif ( $1 =~ /([A-Z_][A-Z_0-9]*)\s+([A-Za-z0-9_.,]+)\s*/) {
				#print "constant $1: $2\n";
				$c_const{$1} = $2;
			} elsif ( $1 =~ /^($CNAME)\s*$/ ) {
				#ignore #print "option $1 is set\n";
			} else {
				#ignore #print "alias $_\n";
			}
		} elsif (/^\s*(?:extern\s+)?(?:($CTYPE)($CNAME)|($CTYPE)\s+($CNAME))\s*\(((?:\s*(?:$CTYPE|\(\s*$CTYPE\s*\))(?:\s+$CNAME)?\s*,?)+)\)[^;]*;/o){
			#print "proto: $1$3 $2$4($5)\n";
			$vars = "";
			foreach ( split /,/, $5 ) {
				if ( /($CTYPE)\s*($CNAME)?/ ) {
					if ( $vars ne "") { $vars = "$vars,"; }
					$vars	= "$vars$1:$2";
				} #else {print "bad monkey $_\n";}
			}
			$tmpstr = "$1$3|$vars";
			if ( $2 ) { $c_proto{$2} = $tmpstr; }
			else { $c_proto{$4} = $tmpstr; }
		}
	}
}
close(FILELIST);

# TODO: fix ordering, dependency in constants/types
print "[constants]\n";
foreach ( keys %c_const ) {
	$c_const{$_} =~ s/[^-0-9A-Za-z_]//g;
	print "$_|$c_const{$_}\n";
}
print "[types]\n";
foreach ( keys %c_type ) {
	print "$_|$c_type{$_}\n";
}
print "[protos]\n";
foreach ( keys %c_proto ) {
	print "$_|$c_proto{$_}\n";
}
exit;
