#include <api/api_main.h>
#include <extension.h>
/* --------------------------------------------------------Utility Commands */
int istrncmp(char *s1, char *s2, int len)
{
	/* case-insensitive strincmp */
	unsigned int x;
	char c1, c2;

	if (!s1 || !s2)
		return (-1);
	for (x = 0; x < len; x++) {
		c1 = toupper(s1[x]);
		c2 = toupper(s2[x]);
		if (c1 < c2)
			return (-1);
		if (c1 > c2)
			return (1);
	}
	return (0);
}

int strtoupper(char *str, int len)
{
	int x;

	for (x = 0; x < len; x++) {
		if (str[x] != 0)
			str[x] = toupper(str[x]);
		else
			break;
	}
	str[len - 1] = 0;
}

//static union {char c[4]; unsigned long l;} endianness = {{'\1','\0','\0','\0'}};
static union {
	char c[4];
	unsigned long l;
} endianness = { {
1, 0, 0, 0}};
int endian_check()
{
	return ((char) endianness.l);
}

/* needed to compare endianness */
extern struct DISASM_TGT target;
extern struct DISASM_ENV disasm_env;
int encmp(char *a, char *b, int len)
{
	int x, y;
	if (target.info.endian == disasm_env.endian)
		return (memcmp(a, b, len));

	for (x = 0, y = len - 1; x < len; x++, y--) {
		if (a[x] != b[y])
			return (a[x] - b[y]);
	}
	return (0);
}
int encmp_short(short a, short b)
{
	return (encmp((char *) &a, (char *) &b, 2));
}
int encmp_int(int a, int b)
{
	return (encmp((char *) &a, (char *) &b, 4));
}

void *encpy(char *dest, char *src, int len)
{
	int x, y;
	if (target.info.endian == disasm_env.endian)
		return (memcpy(dest, src, len));

	for (x = 0, y = len - 1; x < len; x++, y--) {
		dest[x] = src[y];
	}
	return (dest);
}
void *encpy_short(short dest, short src)
{
	return (encpy((char *) &dest, (char *) &src, 2));
}
void *encpy_int(int dest, int src)
{
	return (encpy((char *) &dest, (char *) &src, 4));
}
