
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <bastard.h>

#include "support.h"
#include "sob_ui.h"
#include "sob_ui_prefs.h"
#include "sob_help_win.h"	

GtkWidget *help_main_window = NULL; /* global help-window definition */

int init_help_win(){
	GtkText *t;
	char buf[PATH_MAX];
	struct DISASM_ENV *d_env = env_get_env();
	
	if (! help_main_window ) {
		help_main_window = create_sob_help_win();
	}
	
	t = (GtkText *) lookup_widget(help_main_window, "HelpSOBText");
	
	t = (GtkText *) lookup_widget(help_main_window, "HelpHOWTOText");
	sprintf( buf, "%s/doc/Disasm-HOWTO.txt", d_env->share);
	disp_load_text_from_file( t, buf);
	t = (GtkText *) lookup_widget(help_main_window, "HelpManualText");
	sprintf( buf, "%s/doc/bastard.txt", d_env->share);
	disp_load_text_from_file( t, buf);
	t = (GtkText *) lookup_widget(help_main_window, "HelpAPIText");
	sprintf( buf, "%s/doc/API.txt", d_env->share);
	disp_load_text_from_file( t, buf);
	t = (GtkText *) lookup_widget(help_main_window, "HelpDBText");
	sprintf( buf, "%s/doc/DBSchema.txt", d_env->share);
	disp_load_text_from_file( t, buf);
	t = (GtkText *) lookup_widget(help_main_window, "HelpBCText");
	sprintf( buf, "%s/doc/BCScript.txt", d_env->share);
	disp_load_text_from_file( t, buf);
	t = (GtkText *) lookup_widget(help_main_window, "HelpINTText");
	sprintf( buf, "%s/doc/IntCode.txt", d_env->share);
	disp_load_text_from_file( t, buf);
	
	return(1);
}

int sob_help_show( int page ) {
	GtkNotebook *n;
	
	if ( help_main_window == NULL ) init_help_win();
		
	n = (GtkNotebook *)lookup_widget(help_main_window,  "HelpNotebook");
	
	gtk_notebook_set_page( n, page );
	gtk_widget_show( (GtkWidget *)  help_main_window);
	return(1);
}
