#include <glob.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>

#include <bastard.h>
#include "sob_extensions.h"



GList * get_extensions_in_dir( char *dir) {
	glob_t globbuf;
	char path[PATH_MAX], *buf,  *start;
	int len, x;
	GList *glist = NULL;
	
	/* find all .bc extensions */
	sprintf(path, "%s/*.bc", dir);
	glob(path, 0, NULL, &globbuf);
	for (x=0; x<globbuf.gl_pathc; x++){
		start = strrchr(globbuf.gl_pathv[x], '/') + 1;
		len = strrchr(globbuf.gl_pathv[x], '.') - start;
		buf = malloc(len + 1);
		strncpy( buf, start, len );
		buf[len] = '\0';
		glist = g_list_append(glist, buf);
	}
	globfree(&globbuf);
	
	/* find all .so extensions */

	sprintf(path, "%s/lib*.so", dir);
	glob(path, 0, NULL, &globbuf);
	for (x=0; x<globbuf.gl_pathc; x++){
		start = strrchr(globbuf.gl_pathv[x], '/') + 4;
		len = strrchr(globbuf.gl_pathv[x], '.') - start;
		buf = malloc(len + 1);
		strncpy( buf, start, len );
		buf[len] = '\0';
		glist = g_list_append(glist, buf);
	}
	globfree(&globbuf);
	
	return(glist);			
}

GList * make_glist_for_ext( int ext) {
	char dir[PATH_MAX], *subdir;
	switch (ext) {
		case EXT_FORMAT:
			subdir = "formats";
         	break;
 		case EXT_ARCH:
			subdir = "arch";
         	break;
		case EXT_ASM:
			subdir = "asm";
         	break;
		case EXT_LANG:
			subdir = "lang";
         	break;
		case EXT_COMP:
			subdir = "comp";
         	break;
		case EXT_OS:
			subdir = "os";
         	break;	  
		case EXT_ENGINE:
			subdir = "engines";
			break;
		case EXT_SCRIPT:
			subdir = "scripts";
			break;
		case EXT_PLUGIN:
		default:
			subdir = "plugin";
         	break;

	}
	snprintf(dir, PATH_MAX, "%s/%s", env_get_share(), subdir);
	return(get_extensions_in_dir( dir));
}
