#include <glob.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <bastard.h>

#include "support.h"
#include "db_browse.h"
#include "db/db_query.h"


extern GtkWidget *sob_main_window;

struct tree_node db_tree = {0};

int add_leaf_node(GtkTreeItem *parent, char *label) {
	GtkTree *t;
	GtkTreeItem *i;
	
	t = (GtkTree *)gtk_tree_new();
	gtk_tree_item_set_subtree(parent, (GtkWidget *)t);
		
	i = (GtkTreeItem *)gtk_tree_item_new_with_label(label);
	gtk_tree_append(t, (GtkWidget *)i);	
	gtk_widget_show((GtkWidget *)i);
	return(0);
}

int init_table_count(struct db_table *table, GtkTree *tree){
	GtkTreeItem *node;

	/* 'count' label should be generated dynamically */
	node = (GtkTreeItem*)gtk_tree_item_new_with_label("0");
	gtk_tree_append(tree, (GtkWidget *)node);
	gtk_widget_show((GtkWidget *)node);
	return(0);
}

int init_table_desc(struct db_table *table, GtkTree *tree){
	GtkTreeItem *node;
	db_field *f = table->fields;
	
	while (f) {
		node = (GtkTreeItem *)gtk_tree_item_new_with_label(f->name);
		/* add type value to node data */
		gtk_tree_append(tree, (GtkWidget *)node);
		gtk_widget_show((GtkWidget *)node);
		f = f->next;
	}
	return(0);
}

struct DB_TREE_CB_ITEM {
	db_table *t;
	GtkTree *tree;
};

/* Callbacks for DB Tree */
void expand_db_tree_cb(char *record, struct DB_TREE_CB_ITEM *s){
	char buf[256] = {0};
	GtkTreeItem *item;	

	db_sprint_record(buf, 256, '|', s->t->name, record);
	item = (GtkTreeItem *) gtk_tree_item_new_with_label(buf);
	gtk_tree_append(s->tree, (GtkWidget *)item);
	gtk_widget_show((GtkWidget *)item);
	return;
}

void expand_db_tree(GtkTreeItem *node, db_index *i){
	struct DB_TREE_CB_ITEM s;
	
	s.t = i->table;
	s.tree = (GtkTree *)GTK_TREE_ITEM_SUBTREE(node);
	
	bdb_index_foreach(i->id, (BAPI_CALLBACK)expand_db_tree_cb, &s);
	return;
}
void expand_db_count(GtkTreeItem *node, db_table *t){
	/* set leaf node data */
	GtkTree *tree;
	GtkTreeItem *item;
	char buf[32] = {0};
	
	sprintf(buf, "%d Records", bdb_table_count(t->id));
	tree = (GtkTree *)GTK_TREE_ITEM_SUBTREE(node);
	item = (GtkTreeItem *)gtk_tree_item_new_with_label(buf);
	gtk_tree_append(tree, (GtkWidget *)item);
	gtk_widget_show((GtkWidget *)item);
	
	return;
}

void expand_db_min(GtkTreeItem *node, db_index *i){
	/* set leaf node data */
	GtkTree *tree;
	GtkTreeItem *item;
	db_table *t = i->table;
	char buf[256] = {0};
	char *record = calloc(t->size, 1);
	
	bdb_index_first(i->id, record);	
	db_sprint_record(buf, 256, '|', t->name, record);
	tree = (GtkTree *)GTK_TREE_ITEM_SUBTREE(node);
	item = (GtkTreeItem *)gtk_tree_item_new_with_label(buf);
	gtk_tree_append(tree, (GtkWidget *)item);
	gtk_widget_show((GtkWidget *)item);
	
	free(record);
	return;
}

void expand_db_max(GtkTreeItem *node, db_index *i){
	/* set leaf node data */
	GtkTree *tree;
	GtkTreeItem *item;
	db_table *t = i->table;
	char buf[256] = {0};
	char *record = calloc(t->size, 1);
	
	bdb_index_last(i->id, record);
	db_sprint_record(buf, 256, '|', t->name, record);
	tree = (GtkTree *)GTK_TREE_ITEM_SUBTREE(node);
	item = (GtkTreeItem *)gtk_tree_item_new_with_label(buf);
	gtk_tree_append(tree, (GtkWidget *)item);
	gtk_widget_show((GtkWidget *)item);
	
	free(record);	return;
}

void collapse_db_dyntree(GtkTreeItem *node, db_index *i){
	GtkTree *t;
	gtk_tree_item_remove_subtree(node);	
	
	t = (GtkTree *)gtk_tree_new();
	gtk_tree_item_set_subtree(node, (GtkWidget *)t);
	return;
}

int init_table_index(struct db_table *table, GtkTree *tree){
	GtkTreeItem *node;
	GtkTree *idx_tree, *t;
	db_index *i = table->index;
	
	while (i) {
		node = (GtkTreeItem *)gtk_tree_item_new_with_label(i->name);
		/* add type value to node data */
		gtk_tree_append(tree, (GtkWidget *)node);
		gtk_widget_show((GtkWidget *)node);
		
		/* make subtree for index */
		idx_tree = (GtkTree *)gtk_tree_new();
		gtk_tree_item_set_subtree(node, (GtkWidget *)idx_tree);
		
		/* Add Browse Node */		
		node = (GtkTreeItem *)gtk_tree_item_new_with_label("Browse");
		/* attach signal for user clicking on 'browse' node */   
      gtk_signal_connect (GTK_OBJECT (GTK_TREE_ITEM (node)), "expand",
            (GtkSignalFunc) expand_db_tree, i );
		gtk_signal_connect (GTK_OBJECT (GTK_TREE_ITEM (node)), "collapse",
            (GtkSignalFunc) collapse_db_dyntree, i );
		gtk_tree_append(idx_tree, (GtkWidget *)node);
		gtk_widget_show((GtkWidget *)node);
		t = (GtkTree *)gtk_tree_new();
		gtk_tree_item_set_subtree(node, (GtkWidget *)t);
				
		/* Add Max Node */		
		node = (GtkTreeItem *)gtk_tree_item_new_with_label("Max");
      gtk_signal_connect (GTK_OBJECT (GTK_TREE_ITEM (node)), "expand",
            (GtkSignalFunc) expand_db_max, i );
      gtk_signal_connect (GTK_OBJECT (GTK_TREE_ITEM (node)), "collapse",
            (GtkSignalFunc) collapse_db_dyntree, i );
	  	gtk_tree_append(idx_tree, (GtkWidget *)node);
		gtk_widget_show((GtkWidget *)node);
		t = (GtkTree *)gtk_tree_new();
		gtk_tree_item_set_subtree(node, (GtkWidget *)t);

		/* Add Min Node */		
		node = (GtkTreeItem *)gtk_tree_item_new_with_label("Min");
		gtk_signal_connect (GTK_OBJECT (GTK_TREE_ITEM (node)), "expand",
            (GtkSignalFunc) expand_db_min, i );
      gtk_signal_connect (GTK_OBJECT (GTK_TREE_ITEM (node)), "collapse",
            (GtkSignalFunc) collapse_db_dyntree, i );
		gtk_tree_append(idx_tree, (GtkWidget *)node);
		gtk_widget_show((GtkWidget *)node);
		t = (GtkTree *)gtk_tree_new();
		gtk_tree_item_set_subtree(node, (GtkWidget *)t);
		
		/* Add Primary Key node */		
		node = (GtkTreeItem *)gtk_tree_item_new_with_label("Primary Key");
		gtk_tree_append(idx_tree, (GtkWidget *)node);
		add_leaf_node(node, i->key1->name);
		gtk_widget_show((GtkWidget *)node);
		
		/* Add Secondary Key node */		
		node = (GtkTreeItem *)gtk_tree_item_new_with_label("Secondary Key");
		gtk_tree_append(idx_tree, (GtkWidget *)node);
		if (i->key2) add_leaf_node(node, i->key2->name);
		gtk_widget_show((GtkWidget *)node);
		
		i = i->next;
	}
	return(0);
}

int init_db_tree(){
	GtkTree *tree;
	GtkTreeItem *node;
	struct db_table *table;
	struct db_schema *s;
	struct tree_node *t = &db_tree;
	GtkTree *db_root = (GtkTree *) lookup_widget(sob_main_window, "dbTree");
	
	db_tree.label = "Target";
	s = db_schema_by_name("TARGET");
	for (table = s->tables; table; table = table->next) {
		/* 1. add node for table to root */
		t->next = calloc(sizeof(struct tree_node), 1);
		t = t->next;
		t->label = table->name;
		t->parent = db_root;
		t->node = (GtkTreeItem *)gtk_tree_item_new_with_label(table->name);
		gtk_tree_append(db_root, (GtkWidget *)t->node);
		
		/* 2. Create subtree for table */
		t->subtree = (GtkTree *)gtk_tree_new();
		gtk_tree_item_set_subtree( t->node, (GtkWidget *)t->subtree);

		/* 3. Add COUNT subtree */
		node = (GtkTreeItem *)gtk_tree_item_new_with_label("Count");
		gtk_tree_append(t->subtree, (GtkWidget *)node);
		//tree = gtk_tree_new();
		gtk_signal_connect (GTK_OBJECT (GTK_TREE_ITEM (node)), "expand",
            (GtkSignalFunc) expand_db_count, table );
      	gtk_signal_connect (GTK_OBJECT (GTK_TREE_ITEM (node)), "collapse",
            (GtkSignalFunc) collapse_db_dyntree, table );
		//gtk_tree_item_set_subtree(node, tree);
		//init_table_count(table, tree);
		gtk_widget_show((GtkWidget *)node);
		tree = (GtkTree *)gtk_tree_new();
		gtk_tree_item_set_subtree(node, (GtkWidget *)tree);
	
		
		/* 4. Add DESC subtree */
		node = (GtkTreeItem *)gtk_tree_item_new_with_label("Desc");
		gtk_tree_append(t->subtree, (GtkWidget *)node);
		tree = (GtkTree *)gtk_tree_new();
		gtk_tree_item_set_subtree(node, (GtkWidget *)tree);
		init_table_desc(table, tree);
		gtk_widget_show((GtkWidget *)node);
		
		/* 5. Add INDEX subtree */
		node = (GtkTreeItem *)gtk_tree_item_new_with_label("Index");
		gtk_tree_append(t->subtree, (GtkWidget *)node);
		tree = (GtkTree *)gtk_tree_new();
		gtk_tree_item_set_subtree(node, (GtkWidget *)tree);
		init_table_index(table, tree);
		gtk_widget_show((GtkWidget *)node);
		
		gtk_widget_show((GtkWidget *)t->node);
	}
	return(1);			
}

int clear_db_tree() {
	return(1);
}

