#ifndef SOB_CFG_H
#define SOB_CFG_H


#define SOB_ETC_CFG "/etc/bastard/sob.rc"
#define SOB_USER_CFG "/.bastard/.sobrc"
/* must preface this last one with getenv("HOME"); */

struct SOB_CFG_ITEM;

typedef void (*CFG_READ)( struct SOB_CFG_ITEM *, char * );
typedef void (*CFG_WRITE)( struct SOB_CFG_ITEM *, char *, int );

struct SOB_CFG_ITEM {
	char *name;
	CFG_READ read;
	CFG_WRITE write;
	union {
		GdkColor color;	/* {long pixel, short r, short g, short b } */
		void *p;
		int i;
		GdkFont **font;
	} data;
};


enum sob_env_val { SOBENV_TARGETMOD, SOBENV_TARGETSAVE, 
					SOBENV_CFGMOD };	/* make sure CFG is always last */

struct SOB_ENV_ITEM {
	int value;
	char *name;
};

extern struct SOB_ENV_ITEM sob_env[3];

#define is_target_mod() sob_env[SOBENV_TARGETMOD].value > 0
#define is_target_saved() sob_env[SOBENV_TARGETSAVE].value > 0
#define is_config_mod() sob_env[SOBENV_CFGMOD].value > 0

int process_sob_cfg_file( char *path );
int read_sob_cfg();
int write_sob_cfg();

int get_sob_env( int id );
int set_sob_env( int id, int val );
int get_sob_env_byname( char *name );
int set_sob_env_byname( char *name, int val );

#endif