/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <glob.h>

// Find all the extension (*.so, *.bc) from "dir" directory
// This will fill the specified ComboBox
void FillComboBoxWithExt(char *dir, QComboBox *box)
{
    glob_t globbuf;
    unsigned int i, len;
    char *start, *buf;
    
    // TO DO: The bastard home can also be specified by $BASTARD_HOME...
    char *BastardHome = "/usr/local/bastard";
    char *SharedLib;
    
    // Find all .so files
    // 10 = strlen("/") + strlen("/") + strlen("lib*.so") + "\0"
    SharedLib = new char[strlen(BastardHome) + strlen(dir) + 10];
    strcpy(SharedLib, BastardHome);
    strcat(SharedLib,"/");
    strcat(SharedLib,dir);
    strcat(SharedLib,"/");
    strcat(SharedLib,"lib*.so");
    
    glob(SharedLib, 0, NULL, &globbuf);
    
    for (i = 0; i < globbuf.gl_pathc; i++)
    {
	start = strrchr(globbuf.gl_pathv[i], '/') + 4;
	len = strrchr(globbuf.gl_pathv[i], '.') - start;
	buf = new char[len + 1];
	strncpy( buf, start, len );
	buf[len] = '\0';
	    
	box->insertItem(QString(buf));	
	delete [] buf;
    }
    
    globfree(&globbuf);    
    delete [] SharedLib;
    
    // Find all .bc files
    // 7 = strlen("/") + strlen("/") + strlen("*.bc") + "\0"
    SharedLib = new char[strlen(BastardHome) + strlen(dir) + 7];
    strcpy(SharedLib, BastardHome);
    strcat(SharedLib,"/");
    strcat(SharedLib,dir);
    strcat(SharedLib,"/");
    strcat(SharedLib,"*.bc");
    
    glob(SharedLib, 0, NULL, &globbuf);
    
    for (i = 0; i < globbuf.gl_pathc; i++)
    {
	start = strrchr(globbuf.gl_pathv[i], '/') + 1;
	len = strrchr(globbuf.gl_pathv[i], '.') - start;
	buf = new char[len + 1];
	strncpy( buf, start, len );
	buf[len] = '\0';
	
	box->insertItem(QString(buf));
	delete [] buf;
    }
    
    globfree(&globbuf);    
    delete [] SharedLib;    
}


void LoadTargetDialog::init()
{
    fileLineEdit->setText("");
    openPushButton->setEnabled(FALSE);
    
    fileLineEdit->setFocus();
    openPushButton->setDefault(TRUE);
    
    // Filling the architecture ComboBox
    FillComboBoxWithExt("arch",archComboBox);
    FillComboBoxWithExt("formats",formatComboBox);
    FillComboBoxWithExt("comp",compComboBox);
    FillComboBoxWithExt("os",osComboBox);
    FillComboBoxWithExt("lang",langComboBox);
    FillComboBoxWithExt("asm",asmblComboBox);  
}


void LoadTargetDialog::acceptDialog()
{
    // Tell the dialog caller what the user choosen
    CommonData::newDisasmTarget = new CommonData::t_DisasmTarget;
    
    CommonData::newDisasmTarget->name = new QString;
    *CommonData::newDisasmTarget->name = fileLineEdit->text();
    
    CommonData::newDisasmTarget->arch = new QString;
    *CommonData::newDisasmTarget->arch = archComboBox->currentText();

    CommonData::newDisasmTarget->format = new QString;
    *CommonData::newDisasmTarget->format = formatComboBox->currentText();
    
    CommonData::newDisasmTarget->comp = new QString;
    *CommonData::newDisasmTarget->comp = compComboBox->currentText();
    
    CommonData::newDisasmTarget->lang = new QString;
    *CommonData::newDisasmTarget->lang = langComboBox->currentText();
    
    CommonData::newDisasmTarget->os = new QString;
    *CommonData::newDisasmTarget->os = osComboBox->currentText();
    
    CommonData::newDisasmTarget->asmbl = new QString;
    *CommonData::newDisasmTarget->asmbl = asmblComboBox->currentText();
    
    // Close the dialog
    accept();
}

void LoadTargetDialog::clickBrowse()
{
    QString s = QFileDialog::getOpenFileName(
	    "",			// Initial directory (cwd)
	    "Binaries (*)",		// File type
	    this,
	    "openCommonDlg",	// Inernal name
	    "Choose your target" );
    
    fileLineEdit->setText(s);
    fileNameChanged();
}

void LoadTargetDialog::fileNameChanged()
{
    if (strlen(fileLineEdit->text())) openPushButton->setEnabled(TRUE);
    else openPushButton->setEnabled(FALSE);
}
