#include <glob.h>
#include <qsettings.h>
#include <qcombobox.h>
#include <qlineedit.h>

#include "loadtargetdialog.h"

LoadTargetDialog::LoadTargetDialog(QWidget *parent, char *name=0) : LoadTargetDialogUI(parent, name)
{ 
    /* Fill all those combo box */
    FillComboBoxWithExt("arch",archComboBox);
    FillComboBoxWithExt("formats",formatComboBox);
    FillComboBoxWithExt("comp",compComboBox);
    FillComboBoxWithExt("os",osComboBox);
    FillComboBoxWithExt("lang",langComboBox);
    FillComboBoxWithExt("asm",asmblComboBox);      
}


// Find all the extension (*.so, *.bc) from "dir" directory
// This will fill the specified ComboBox
void LoadTargetDialog::FillComboBoxWithExt(char *dir, QComboBox *box)
{
    glob_t globbuf;
    unsigned int i, len;
    char *start, *buf;
    char *SharedLib;
    
    // Get the bastard home
    QSettings set;
    const char *BastardHome = (set.readEntry("/qbastard/Path/InstallPath")).latin1();
    
    // Find all .so files
    // 10 = strlen("/") + strlen("/") + strlen("lib*.so") + "\0"
    SharedLib = new char[strlen(BastardHome) + strlen(dir) + 10];
    strcpy(SharedLib, BastardHome);
    strcat(SharedLib,"/");
    strcat(SharedLib,dir);
    strcat(SharedLib,"/");
    strcat(SharedLib,"lib*.so");
    
    glob(SharedLib, 0, NULL, &globbuf);
    
    for (i = 0; i < globbuf.gl_pathc; i++)
    {
	start = strrchr(globbuf.gl_pathv[i], '/') + 4;
	len = strrchr(globbuf.gl_pathv[i], '.') - start;
	buf = new char[len + 1];
	strncpy( buf, start, len );
	buf[len] = '\0';
	    
	box->insertItem(QString(buf));	
	delete [] buf;
    }
    
    globfree(&globbuf);    
    delete [] SharedLib;
    
    // Find all .bc files
    // 7 = strlen("/") + strlen("/") + strlen("*.bc") + "\0"
    SharedLib = new char[strlen(BastardHome) + strlen(dir) + 7];
    strcpy(SharedLib, BastardHome);
    strcat(SharedLib,"/");
    strcat(SharedLib,dir);
    strcat(SharedLib,"/");
    strcat(SharedLib,"*.bc");
    
    glob(SharedLib, 0, NULL, &globbuf);
    
    for (i = 0; i < globbuf.gl_pathc; i++)
    {
	start = strrchr(globbuf.gl_pathv[i], '/') + 1;
	len = strrchr(globbuf.gl_pathv[i], '.') - start;
	buf = new char[len + 1];
	strncpy( buf, start, len );
	buf[len] = '\0';
	
	box->insertItem(QString(buf));
	delete [] buf;
    }
    
    globfree(&globbuf);    
    delete [] SharedLib;    
}


void LoadTargetDialog::acceptDialog(void) 
{
    // Tell the dialog caller what the user choosen
    t_DisasmTarget *newDisasmTarget = new t_DisasmTarget;
    
    newDisasmTarget->name = new QString;
    *newDisasmTarget->name = fileLineEdit->text();
    
    newDisasmTarget->arch = new QString;
    *newDisasmTarget->arch = archComboBox->currentText();

    newDisasmTarget->format = new QString;
    *newDisasmTarget->format = formatComboBox->currentText();
    
    newDisasmTarget->comp = new QString;
    *newDisasmTarget->comp = compComboBox->currentText();
    
    newDisasmTarget->lang = new QString;
    *newDisasmTarget->lang = langComboBox->currentText();
    
    newDisasmTarget->os = new QString;
    *newDisasmTarget->os = osComboBox->currentText();
    
    newDisasmTarget->asmbl = new QString;
    *newDisasmTarget->asmbl = asmblComboBox->currentText();
    
    emit newTarget(newDisasmTarget);
    
    // Close the dialog
    accept();
}
