#include <qlabel.h>
#include <qtextedit.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

#include "infopanel.h"

void InfoPanel::setInfo(InfoAddr *i)
{
    rva = i->getRVA();
    
    labelRVA->setText(QString("0x%1").arg(i->getRVA(), 0, 16));
    labelPA->setText(QString("0x%1").arg(i->getPA(), 0, 16));
    labelFunction->setText(QString(i->getFunctionName()));
    labelSection->setText(QString(i->getSectionName()));
    editComment->setText(QString(i->getCodeComment()));
    
    buttonApply->setEnabled(FALSE);
}


void InfoPanel::applyClicked(void)
{
    /* Check of the comment does not exceed 255 characters (bdb limit...) */
    if (strlen(editComment->text().latin1()) > 255)
    {
	QMessageBox::information(this, QString("Sorry, you can't have a comment with more than 255 characters because of a limitation of the libbastard database. The comment is not saved."), QString("&OK"));
    }
    else
    {
	bastard->changeCodeComment(rva, (char *)(editComment->text().latin1()));
	buttonApply->setEnabled(FALSE);
    }       
}


void InfoPanel::commentChanged(void)
{
    buttonApply->setEnabled(TRUE);
}
