#include <string.h>

#include "infoaddr.h"


InfoAddr::InfoAddr(void)
{
    rva = 0;
    pa = 0;
    addrLen = 0;
    funcName = NULL;
    sectName = NULL;
    codeComment = NULL;
}


InfoAddr::~InfoAddr()
{
    if (funcName) delete [] funcName;
    if (sectName) delete [] sectName;
    if (codeComment) delete [] codeComment;
}


void InfoAddr::setFunctionName(char *f)
{
    if (funcName) delete [] funcName;
    funcName = new char[strlen(f)+1];
    strcpy(funcName, f);
}


void  InfoAddr::setSectionName(char *s)
{
    if (sectName) delete [] sectName;
    sectName = new char[strlen(s)+1];
    strcpy(sectName, s);    
}


void  InfoAddr::setCodeComment(char *c)
{
    if (codeComment) delete [] codeComment;
    codeComment = new char[strlen(c)+1];
    strcpy(codeComment, c);
}
