#include "databasedumpdialog.h"
#include <qtable.h>

      /* SECTION TYPES */
#define SECTION_HDR      0x1000
#define SECTION_CODE   0x1100
#define SECTION_DATA   0x1200
#define SECTION_RSRC   0x1300
#define SECTION_IMPORT   0x1400
#define SECTION_EXPORT   0x1500
#define SECTION_DEBUG   0x1600
#define SECTION_CMT      0x1700
#define SECTION_RELOC   0x1800

const char sectionTypeName[][10] = {
    "HDR", "CODE", "DATA", "RSRC", "IMPORT", "EXPORT", "DEBUG", "CMT", "RELOC" };

       /* SECTION PERMISSIONS */
#define SECTION_EXECUTE   0x01
#define SECTION_WRITE   0x02
#define SECTION_READ   0x04

      /* SECTION MASKS */
#define SECTION_TYPE_MASK 0xFF00
#define SECTION_PERM_MASK 0x000F

DatabaseDumpDialog::DatabaseDumpDialog(BastardObject *b, QWidget *p, char *name = 0) : DatabaseDumpDialogUI(p, name)
{
    bastard = b;
    
    sectionDumpConnected = false;
    addressDumpConnected = false;
    codeDumpConnected = false;
    functionDumpConnected = false;
    
    sectionDump();
    addressDump();
    codeDump();
    functionDump();
}


void DatabaseDumpDialog::sectionDump(void)
{
    int i = 0;
    vector<struct section>::iterator it;
    vector<struct section> *listSec;
    struct section sec;
    QString s;
    
    if (!(listSec = bastard->getSectionList()))
    {
	/* The info is not available right now, we will asks for the info and wait that we get called back */
	connect(bastard, SIGNAL(readySectionList()), this, SLOT(sectionDump()));
	sectionDumpConnected = true;
	return;
    }
    else
    {
	if (sectionDumpConnected)
	{
	    disconnect(bastard, SIGNAL(readySectionList()), 0, 0);
	    sectionDumpConnected = false;
	}
    }
    
    tableSection->setNumRows(listSec->size());
    tableSection->setNumCols(5);
    
    (tableSection->horizontalHeader())->setLabel(0, QString("name"));
    (tableSection->horizontalHeader())->setLabel(1, QString("rva"));
    (tableSection->horizontalHeader())->setLabel(2, QString("size"));
    (tableSection->horizontalHeader())->setLabel(3, QString("Permission"));
    (tableSection->horizontalHeader())->setLabel(4, QString("Type"));
    
    for (it = listSec->begin(); it != listSec->end(); it++)
    {
	sec = *it;
	
	tableSection->setText(i, 0, QString(sec.name));
	
	s = QString("%1").arg(sec.rva, 0, 16);
	tableSection->setText(i, 1, s);
		       
	s = QString("%1").arg(sec.size);
	tableSection->setText(i, 2, s);
	
	s = QString("%1%2%3").arg(sec.flags & SECTION_READ ? "r" : "-")
	                                  .arg(sec.flags & SECTION_WRITE ? "w" : "-")
			          .arg(sec.flags & SECTION_EXECUTE ? "x" : "-");
	tableSection->setText(i, 3, s);
	
	if (sec.flags & 0xFF00 >= 0x1000 && sec.flags & 0xFF00 < 0x1900)
	    s = QString(sectionTypeName[(sec.flags >> 16) & 0xF]);
	else
	    s = QString("?");
	
	tableSection->setText(i, 4, s);
	
	i++;
    }
}


void DatabaseDumpDialog::addressDump(void)
{
    int i = 0;
    vector<struct address>::iterator it;
    vector<struct address> *listAddr;
    struct address addr;
    QString s;
    
    if (!(listAddr = bastard->getAddressList()))
    {
	/* The info is not available right now, we will asks for the info and wait that we get called back */
	connect(bastard, SIGNAL(readyAddressList()), this, SLOT(addressDump()));
	addressDumpConnected = true;
	return;
    }
    else
    {
	if (addressDumpConnected)
	{
	    disconnect(bastard, SIGNAL(readyAddressList()), 0, 0);
	    addressDumpConnected = false;
	}
    }
   
    tableAddress->setNumRows(listAddr->size());
    tableAddress->setNumCols(9);
    
    (tableAddress->horizontalHeader())->setLabel(0, QString("rva"));
    (tableAddress->horizontalHeader())->setLabel(1, QString("pa"));
    (tableAddress->horizontalHeader())->setLabel(2, QString("size"));
    (tableAddress->horizontalHeader())->setLabel(3, QString("flags"));
    (tableAddress->horizontalHeader())->setLabel(4, QString("dataType"));
    (tableAddress->horizontalHeader())->setLabel(5, QString("dataSize"));
    (tableAddress->horizontalHeader())->setLabel(6, QString("dataConst"));
    (tableAddress->horizontalHeader())->setLabel(7, QString("structure"));
    (tableAddress->horizontalHeader())->setLabel(8, QString("comment"));
    
    for (it = listAddr->begin(); it != listAddr->end(); it++)
    {
	addr = *it;

	s = QString("%1").arg(addr.rva, 0, 16);
	tableAddress->setText(i, 0, s);
	
	s = QString("%1").arg(addr.pa, 0, 16);
	tableAddress->setText(i, 1, s);
		       
	s = QString("%1").arg(addr.size);
	tableAddress->setText(i, 2, s);
	
	s = QString("%1").arg(addr.flags, 0, 16);
	tableAddress->setText(i, 3, s);
	
	s = QString("%1").arg(addr.dataType, 0, 16);
	tableAddress->setText(i, 4, s);
	
	s = QString("%1").arg(addr.dataSize, 0, 16);
	tableAddress->setText(i, 5, s);
	
	s = QString("%1").arg(addr.dataConst, 0, 16);
	tableAddress->setText(i, 6, s);
	
	s = QString("%1").arg(addr.structure, 0, 16);
	tableAddress->setText(i, 7, s);	
	
	s = QString("%1").arg(addr.comment, 0, 16);
	tableAddress->setText(i, 8, s);	
		
	i++;
    }    
}


void DatabaseDumpDialog::codeDump(void)
{
    int i = 0;
    vector<struct code>::iterator it;
    vector<struct code> *listCode;
    struct code cod;
    QString s;
    
    if (!(listCode = bastard->getCodeList()))
    {
	/* The info is not available right now, we will asks for the info and wait that we get called back */
	connect(bastard, SIGNAL(readyCodeList()), this, SLOT(codeDump()));
	codeDumpConnected = true;
	return;
    }
    else
    {
	if (codeDumpConnected)
	{
	    disconnect(bastard, SIGNAL(readyCodeList()), 0, 0);
	    codeDumpConnected = false;
	}
    }
   
    tableCode->setNumRows(listCode->size());
    tableCode->setNumCols(10);
    
    (tableCode->horizontalHeader())->setLabel(0, QString("rva"));
    (tableCode->horizontalHeader())->setLabel(1, QString("func"));
    (tableCode->horizontalHeader())->setLabel(2, QString("mnemonic"));
    (tableCode->horizontalHeader())->setLabel(3, QString("dest"));
    (tableCode->horizontalHeader())->setLabel(4, QString("src"));
    (tableCode->horizontalHeader())->setLabel(5, QString("aux"));
    (tableCode->horizontalHeader())->setLabel(6, QString("mnemType"));
    (tableCode->horizontalHeader())->setLabel(7, QString("destType"));
    (tableCode->horizontalHeader())->setLabel(8, QString("srcType"));
    (tableCode->horizontalHeader())->setLabel(9, QString("auxType"));
    
    for (it = listCode->begin(); it != listCode->end(); it++)
    {
	cod = *it;

	s = QString("%1").arg(cod.rva, 0, 16);
	tableCode->setText(i, 0, s);
	
	s = QString("%1").arg(cod.func, 0, 16);
	tableCode->setText(i, 1, s);
		       
	s = QString(cod.mnemonic);
	tableCode->setText(i, 2, s);
	
	s = QString("%1").arg(cod.dest, 0, 16);
	tableCode->setText(i, 3, s);
	
	s = QString("%1").arg(cod.src, 0, 16);
	tableCode->setText(i, 4, s);
	
	s = QString("%1").arg(cod.aux, 0, 16);
	tableCode->setText(i, 5, s);
	
	s = QString("%1").arg(cod.mnemType, 0, 16);
	tableCode->setText(i, 6, s);
	
	s = QString("%1").arg(cod.destType, 0, 16);
	tableCode->setText(i, 7, s);	
	
	s = QString("%1").arg(cod.srcType, 0, 16);
	tableCode->setText(i, 8, s);
	
	s = QString("%1").arg(cod.auxType, 0, 16);
	tableCode->setText(i, 9, s);
		
	i++;
    }    
}


void DatabaseDumpDialog::functionDump(void)
{
    int i = 0;
    vector<struct function>::iterator it;
    vector<struct function> *listFunc;
    struct function func;
    QString s;
    
    if (!(listFunc = bastard->getFunctionList()))
    {
	/* The info is not available right now, we will asks for the info and wait that we get called back */
	connect(bastard, SIGNAL(readyFunctionList()), this, SLOT(functionDump()));
	functionDumpConnected = true;
	return;
    }
    else
    {
	if (functionDumpConnected)
	{
	    disconnect(bastard, SIGNAL(readyFunctionList()), 0, 0);
	    functionDumpConnected = false;
	}
    }
   
    tableFunction->setNumRows(listFunc->size());
    tableFunction->setNumCols(5);
    
    (tableFunction->horizontalHeader())->setLabel(0, QString("id"));
    (tableFunction->horizontalHeader())->setLabel(1, QString("rva"));
    (tableFunction->horizontalHeader())->setLabel(2, QString("size"));
    (tableFunction->horizontalHeader())->setLabel(3, QString("ret_type"));
    (tableFunction->horizontalHeader())->setLabel(4, QString("comment"));

    
    for (it = listFunc->begin(); it != listFunc->end(); it++)
    {
	func = *it;

	s = QString("%1").arg(func.id, 0, 16);
	tableFunction->setText(i, 0, s);
	
	s = QString("%1").arg(func.rva, 0, 16);
	tableFunction->setText(i, 1, s);
		       
	s = QString("%1").arg(func.size);
	tableFunction->setText(i, 2, s);
	
	s = QString("%1").arg(func.ret_type, 0, 16);
	tableFunction->setText(i, 3, s);
	
	s = QString("%1").arg(func.comment, 0, 16);
	tableFunction->setText(i, 4, s);
	
	i++;
    }    
}


