/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <qregexp.h>
#include <qmessagebox.h>
#include <qsettings.h>
#include <qfiledialog.h>

#define DEFAULT_INSTALL_PATH QString("/usr/local/bastard")
#define DEFAULT_DATABASE_PATH QString("%1/.bastard").arg(getenv("HOME"))

void ConfigDialog::init()
{
    QSettings set;
    
    databasePathLineEdit->setText(set.readEntry("/qbastard/Path/DatabasePath"));
    installPathLineEdit->setText(set.readEntry("/qbastard/Path/InstallPath"));
}

void ConfigDialog::setDefaultDatabasePath(void)
{
    databasePathLineEdit->setText(DEFAULT_DATABASE_PATH);
}

void ConfigDialog::setDefaultInstallPath(void)
{
    installPathLineEdit->setText(DEFAULT_INSTALL_PATH);
}

void ConfigDialog::browseDatabasePath()
{
    QString s = QFileDialog::getExistingDirectory(getenv("HOME"), this, "browseDatabasePath",
						  QString(tr("Choose database directory")));
    
    if (s != QString::null) databasePathLineEdit->setText(s);
}

void ConfigDialog::browseInstallPath()
{
    QString s = QFileDialog::getExistingDirectory("/", this, "browseInstallPath",
						  QString(tr("Choose installation directory")));
    
    if (s != QString::null) installPathLineEdit->setText(s);
}

void ConfigDialog::okButton(void)
{
    struct stat dirStat;
    
    // Check the validity of the path entered by the user
    // Replace the ~ with the user home
    installPathLineEdit->setText((installPathLineEdit->text()).replace(QRegExp("~"),getenv("HOME")));
    databasePathLineEdit->setText((databasePathLineEdit->text()).replace(QRegExp("~"),getenv("HOME")));
    
    // Check if the file exists and it is an actual directory
    if (stat((installPathLineEdit->text()).latin1(), &dirStat))
    {
	QMessageBox::information(this,
				 QString("Error"),
				 QString("The install directory does not exists!"));
	return;
    }
    if (!(dirStat.st_mode & S_IFDIR))
    {
	QMessageBox::information(this,
				 QString("Error"),
				 QString("The install directory is actually a file!"));
	return;
    }
    
    if (stat((databasePathLineEdit->text()).latin1(), &dirStat))
    {
	if(QMessageBox::warning(this,
				    QString("Warning"),
				    QString("The database directory does not exists! Shall I create it?"), 
				    "Yes",
				    "No",
				    0, 1))	
	    return;
	else
	    mkdir((databasePathLineEdit->text()).latin1(), 0700);
    }
    else
    {	
	if (!(dirStat.st_mode & S_IFDIR))
	{
	    QMessageBox::information(this,
				     QString("Error"),
				     QString("The database directory is actually a file!"));
	    return;
	}
    }
    
    QSettings set;
    
    set.writeEntry("/qbastard/Path/InstallPath", installPathLineEdit->text());
    set.writeEntry("/qbastard/Path/DatabasePath", databasePathLineEdit->text());
    
    accept();
}



void ConfigDialog::pathChanged(void)
{
    // Both lineedit must be non-null to be able to press the ok button
    if ((installPathLineEdit->text()).isEmpty() ||
        (databasePathLineEdit->text()).isEmpty()) buttonOk->setEnabled(FALSE);
    else buttonOk->setEnabled(TRUE);
    
    // Disable and enable the default button
    if (installPathLineEdit->text() == DEFAULT_INSTALL_PATH) defaultInstallPathPushButton->setEnabled(FALSE);
    else defaultInstallPathPushButton->setEnabled(TRUE);
	
    if (databasePathLineEdit->text() == DEFAULT_DATABASE_PATH) defaultDatabasePathPushButton->setEnabled(FALSE);
    else defaultDatabasePathPushButton->setEnabled(TRUE);
}
