#ifndef __CENTRALWIDGET_H__
#define __CENTRALWIDGET_H__

#include <qwidget.h>
#include <qsplitter.h>
#include <qtabwidget.h>

#include <list>

#include "bastardobject.h"
#include "infopanel.h"
#include "QHexEdit/qhexedit.h"
#include "QAsmEdit/qasmedit.h"

/* Associate a struct function to a asmWidget and also a ticketId */
struct t_Function2Widget
{
    QAsmEdit *widget;
    BastardFunction *func;
    unsigned int ticket;
};
    

class CentralWidget : public QWidget
{
    Q_OBJECT
    
    public:    
    CentralWidget(BastardObject *bo, QWidget *parent, char *name = 0);
    ~CentralWidget();
    
    virtual void resizeEvent(QResizeEvent *);
    
    
    public slots:
    void init(void);
    void newTicket(unsigned int, void *);
    void asmClickOnRVA(unsigned int, ButtonState);
    void asmTabChanged(QWidget *);
    
    
    private:
    BastardObject *bastard;
    struct DISASM_TGT *genInfo;
    
    QHexEdit *hexWidget;
    InfoPanel *infoPanel;
    QSplitter *vertSplit, *horSplit;
    QTabWidget *asmTable;
    
    unsigned int infoRequestTicket;
    unsigned int hexWidgetHighlight;
    
    list<t_Function2Widget> asmWidgetList;
};

#endif
