#ifndef __BASTARDTHREAD_H__
#define __BASTARDTHREAD_H__

#include <qthread.h>
#include <qsemaphore.h>

#include <list>
#include <vector>

extern "C" {
#include <bastard.h>
}

#include "bastardfunction.h"
#include "infoaddr.h"

// Message from BastardThread to BastardGUI
enum t_ThreadMessage { ThreadReady, ThreadMessage };

// Message from BastardGUI to BastardThread
enum t_BastardMsg { 
    BASTARD_NO_CMD, 
    BASTARD_TARGET_LOAD, 
    BASTARD_TARGET_SET_FORMAT,
    BASTARD_TARGET_SET_ARCH,
    BASTARD_TARGET_SET_ASM,
    BASTARD_TARGET_SET_LANG,
    BASTARD_TARGET_SET_OS,
    BASTARD_TARGET_SET_COMP,
    BASTARD_TARGET_APPLY_FORMAT,
    BASTARD_DISASM_TARGET,
    BASTARD_DISASM_SECTION,
    BASTARD_TARGET_SAVE_ASM,
    BASTARD_SYS_QUIT,
    BASTARD_TARGET_SAVE_DB_AS,
    BASTARD_TARGET_LOAD_BDB,
    
    GET_DUMP_SECTION,
    GET_DUMP_ADDRESS,
    GET_DUMP_CODE,
    GET_DUMP_FUNCTION,
    
    GET_CODE_SECTION,
    GET_CODE_FUNCTION,
    
    BASTARD_GET_TARGET_IMAGE,
    BASTARD_GET_TARGET_INFO,
    GET_FUNCTION_RVA,
    GET_SECTION_RVA,
    TRY_JUMP_FROM,
    GET_INFO_ADDR,
    
    CHANGE_CODE_COMMENT
};


// Used when replying to BastardObject
struct t_ReplyMsg
{
    t_BastardMsg msg;
    void *arg;
    unsigned int ticketId;
};

// Used to keep track of all the message that are needed to be sent to the bastard, used in BastardObject
struct t_BastardMsgList
{
    t_BastardMsg msg;
    void *arg;
    unsigned int ticketId;
};

class BastardThread: public QThread
{
public:
  BastardThread(QObject *o) : 
    receiver(o) { }
  
  void setInstallPath(QString i) { installPath = i; }

  void run();
  void stop();
  
  // Current message sent by BastardObject to the thread
  static t_BastardMsg msg;
  static void *msgArg;
  static unsigned int ticketId;
  
  static QSemaphore *semaphore;  

private:
  QObject *receiver;
  QString installPath;
  
  int tube[2];
  
  char **GetAllSectionName(void);
  char *GetSectionContent(char *);
  
  vector<struct section> *GetDumpSection(void);
  vector<struct address> *GetDumpAddress(void);
  vector<struct code> *GetDumpCode(void);
  vector<struct function> *GetDumpFunction(void);
  
  vector<struct t_CodeDump> *GetCodeSection(struct section *a);
  vector<t_CodeDump> *GetCodeFunction(BastardFunction *f);
  BastardFunction *GetFunctionRVA(unsigned int);
  struct section *GetSectionRVA(unsigned int);
  BastardFunction *tryJumpFrom(unsigned int);
  InfoAddr *getInfoAddr(unsigned int);
  
  void changeCodeComment(unsigned int rva, char *newComment);
  
  void SendReply(void *, t_BastardMsg, unsigned int);
};

#endif //__BASTARDTHREAD_H__
