#include "bastardthread.h"
#include "bastardobject.h"
#include <iostream.h>
#include <qevent.h>
#include <unistd.h>

#include <list>
#include <vector>

enum t_BastardMsg BastardThread::msg = BASTARD_NO_CMD;
void *BastardThread::msgArg = NULL;
unsigned int BastardThread::ticketId = 0;

QSemaphore *BastardThread::semaphore = NULL;

/* TO DO: find a better way to obtain this string */
char *asmfmt = "%m %d%, %s%, %t";

void BastardThread::run()
{    
    int ret;
    pid_t *pid;
    char *buf;
    
    // We will redirect "stdout" to "tube[0]"
    /*pipe(tube);
    dup2(tube[1],1);*/
    
    // Init the bastard lib
    buf = new char[strlen(installPath.latin1()) + 1];
    strcpy(buf, installPath.latin1());
    sys_init(buf);
    env_set_option( "DONT_SAVE" );
    delete [] buf;
    
    // Tell BastardGUI that we are alive and ready
    // We send the pid of the thread when  we are ready
    QCustomEvent *ev = new QCustomEvent(12345);
    pid = new pid_t;
    *pid = getpid();
    ev->setData(pid);
    QThread::postEvent(receiver, ev);
  
    // Infinite loop that will dispatch calls
    do
    {
	// Block while waiting for an event
	(*semaphore)++;
      
	// Dispatch the command
	switch (msg)
	{	    
	case BASTARD_TARGET_LOAD:
	    ret = target_load((char *)msgArg);
	    delete [] (char *)msgArg;
	    break;
	
	case BASTARD_TARGET_SET_FORMAT:
	    ret = target_set_format((char *)msgArg, 0);  
	    delete [] (char *)msgArg;	  
	    break;
	    
	case BASTARD_TARGET_SET_ARCH:
	    ret = target_set_arch((char *)msgArg, 0);  	    
	    delete [] (char *)msgArg;	  
	    break;
	    
	case BASTARD_TARGET_SET_ASM:
	    ret = target_set_asm((char *)msgArg, 0);
	    delete [] (char *)msgArg;	  
	    break;
	    
	case BASTARD_TARGET_SET_LANG:
	    ret = target_set_lang((char *)msgArg, 0);    
	    delete [] (char *)msgArg;	  
	    break;
	    
	case BASTARD_TARGET_SET_OS:
	    ret = target_set_os((char *)msgArg, 0);	    
	    delete [] (char *)msgArg;	  
	    break;
	    
	case BASTARD_TARGET_SET_COMP:
	    ret = target_set_comp((char *)msgArg, 0);
	    delete [] (char *)msgArg;	  
	    break;
	    
	case BASTARD_TARGET_APPLY_FORMAT:
	    target_apply_format();
	    break;
	    
	case BASTARD_DISASM_SECTION:
	    ret = disasm_section((char *)msgArg);  
	    delete [] (char *)msgArg;	  
	    break;
	    
	case BASTARD_TARGET_SAVE_ASM:
	    ret = target_save_asm((char *)msgArg);	    
	    delete [] (char *)msgArg;
	    break;
	    
	case BASTARD_DISASM_TARGET:
	    ret = disasm_target((char *)msgArg, NULL);
	    SendReply(NULL, BASTARD_DISASM_TARGET, ticketId);
	    delete [] (char *)msgArg;	  
	    break;
	    
	case BASTARD_SYS_QUIT:
	    sys_quit();
	    SendReply(NULL, BASTARD_SYS_QUIT, ticketId);
	    
	    exit();		// Kill the thread
	    
	    break;
	    
	case BASTARD_TARGET_SAVE_DB_AS:
	    target_save_db_as((char *)msgArg);
	    delete [] (char *)msgArg;
	    break;
	    
	case  BASTARD_TARGET_LOAD_BDB:
	    target_load_bdb((char *)msgArg);
	    SendReply(NULL, BASTARD_TARGET_LOAD_BDB, ticketId);
	    delete [] (char *)msgArg;
	    break;

	    	    
	case GET_DUMP_SECTION:
	    SendReply(GetDumpSection(), GET_DUMP_SECTION, ticketId);
	    break;
	    
	case GET_DUMP_ADDRESS:
	    SendReply(GetDumpAddress(), GET_DUMP_ADDRESS, ticketId);
	    break;
	    
	case GET_DUMP_CODE:
	    SendReply(GetDumpCode(), GET_DUMP_CODE, ticketId);
	    break;
	    
	case GET_DUMP_FUNCTION:
	    SendReply(GetDumpFunction(), GET_DUMP_FUNCTION, ticketId);
	    break;
	    
	    
	case GET_CODE_SECTION:
	    SendReply(GetCodeSection((section *)msgArg), GET_CODE_SECTION, ticketId);
	    delete (section *)msgArg;
	    break;
	    
	case GET_CODE_FUNCTION:
	    SendReply(GetCodeFunction((BastardFunction *)msgArg), GET_CODE_FUNCTION, ticketId);
	    delete (function *)msgArg;
	    break;	
	    
	case BASTARD_GET_TARGET_IMAGE:
	    SendReply(target_image(), BASTARD_GET_TARGET_IMAGE, ticketId);
	    break;
	    
	case BASTARD_GET_TARGET_INFO:
	    SendReply(env_get_target(), BASTARD_GET_TARGET_INFO, ticketId);
	    break;
	    
	case GET_FUNCTION_RVA:
	    SendReply(GetFunctionRVA(*((unsigned int *)msgArg)), GET_FUNCTION_RVA, ticketId);
	    delete (unsigned int *) msgArg;
	    break;
	    
	case GET_SECTION_RVA:
	    SendReply(GetSectionRVA(*((unsigned int *)msgArg)), GET_SECTION_RVA, ticketId);
	    delete (unsigned int *) msgArg;
	    break;
	    
	case TRY_JUMP_FROM:
	    SendReply(tryJumpFrom(*((unsigned int *)msgArg)), TRY_JUMP_FROM, ticketId);
	    delete (unsigned int *) msgArg;
	    break;
	    
	case GET_INFO_ADDR:
	    SendReply(getInfoAddr(*((unsigned int *)msgArg)), GET_INFO_ADDR, ticketId);
	    delete (unsigned int *) msgArg;
	    break;
	    
	case CHANGE_CODE_COMMENT:
	    changeCodeComment(((t_RVAString *)msgArg)->rva, ((t_RVAString *)msgArg)->str);
	    delete [] ((t_RVAString *)msgArg)->str;
	    delete (t_RVAString *) msgArg;
	    break;
	    
	    
	    default:
	    break;
	}
	
	// Tell BastardGUI that we are ready for the next command
	QCustomEvent *ev = new QCustomEvent(12345);
	pid = new pid_t;
	*pid = getpid();
	ev->setData(pid);
	QThread::postEvent(receiver, ev);
    }
    while (1);
}	


void BastardThread::stop()
{
    qDebug("BastardThread received stop()");
}


vector<struct section> *BastardThread::GetDumpSection(void)
{
    int cont;
    struct section sec;
    
    vector<struct section> *ret;
    ret = new vector<struct section>;
    
    cont = bdb_index_first(SECTION_NAME, &sec);
    
    while (cont)
    {		
	ret->push_back(sec);
	
	cont = bdb_index_next(SECTION_NAME, &sec);
    }
    
    return ret;
}


vector<struct address> *BastardThread::GetDumpAddress(void)
{
    db_table *t;
    db_result *r;

    vector<struct address> *ret;
    ret = new vector<struct address>;
    
    t = db_table_by_name(db_schema_by_name("TARGET"), "ADDRESS");
    r = db_table_get(t);
    
    while(r)
    {
	ret->push_back((*(struct address *)r->data));
	r = r->next;
    }

    return ret;
}



vector<struct code> *BastardThread::GetDumpCode(void)
{
    db_table *t;
    db_result *r;

    vector<struct code> *ret;
    ret = new vector<struct code>;
    
    t = db_table_by_name(db_schema_by_name("TARGET"), "CODE");
    r = db_table_get(t);
    
    while(r)
    {
	ret->push_back(*((struct code *)r->data));
	r = r->next;
    }

    return ret;
}


vector<struct function> *BastardThread::GetDumpFunction(void)
{
    db_table *t;
    db_result *r;

    vector<struct function> *ret;
    ret = new vector<struct function>;
    
    t = db_table_by_name(db_schema_by_name("TARGET"), "FUNCTION");
    r = db_table_get(t);
    
    while(r)
    {
	ret->push_back(*((struct function *)r->data));
	r = r->next;
    }

    return ret;
}



vector<t_CodeDump> *BastardThread::GetCodeSection(struct section *s)
{
    struct code c;
    char buf[2048];
    vector<t_CodeDump> *ret = new vector<t_CodeDump>;
    t_CodeDump codeDump;
    
    /* TO DO: this code is very slow, we need to optimise, less call to asmsprintf, and manage to obtain the lenght of the vector before we start */
    
    /* Find the first line of code in this section */
    if (!bdb_index_find(CODE_RVA, &(s->rva), &c))
    {
	if (!bdb_find_closest_next(CODE_RVA, &(s->rva), &c)) return ret;
    }
    
    /* Dump a line for each line of code in the section */
    while ((s->rva + s->size) >= c.rva)
    {
	codeDump.rva = c.rva;
	
	/* Get the label */
	asmsprintf(buf, "%n%:", GetAddressObject(c.rva));
	if (*buf)
	{
	    codeDump.label = new char[strlen(buf) + 1];
	    strcpy(codeDump.label, buf);
	    
	    codeDump.instr = NULL;
	    codeDump.comment = NULL;
	    
	    /* An address with a label always have a line alone */
	    ret->push_back(codeDump);
	}	
	codeDump.label = NULL;
	
	/* Get the instruction */
	asmsprintf(buf, asmfmt, GetAddressObject(c.rva));	
	codeDump.instr = new char[strlen(buf)+1];
	strcpy(codeDump.instr, buf);
	
	/* Get the comment */
	asmsprintf(buf, "%c", GetAddressObject(c.rva));	
	if (*buf)
	{
	    codeDump.comment = new char[strlen(buf) + 1];
	    strcpy(codeDump.comment, buf);
	}
	else
	    codeDump.comment = NULL;
	
	/* Add to the vector */
	ret->push_back(codeDump);
	
	if (!bdb_index_next(CODE_RVA, &c)) break;
    }
    
    return ret;
}


vector<t_CodeDump> *BastardThread::GetCodeFunction(BastardFunction *f)
{
    struct code c;
    char buf[2048];
    vector<t_CodeDump> *ret = new vector<t_CodeDump>;
    t_CodeDump codeDump;
    
    unsigned int rva;
    
    /* TO DO: this code is very slow, we need to optimise, less call to asmsprintf, and manage to obtain the lenght of the vector before we start */
    
    /* Find the first line of code in this section */
    rva = f->getRVA();
    if (!bdb_index_find(CODE_RVA, &rva, &c))
    {
	if (!bdb_find_closest_next(CODE_RVA, &rva, &c)) return ret;
    }
    
    /* Dump a line for each line of code in the section */
    while ((f->getRVA() + f->getSize()) >= c.rva)
    {
	codeDump.rva = c.rva;
	
	/* Get the label */
	asmsprintf(buf, "%n%:", GetAddressObject(c.rva));
	if (*buf)
	{
	    codeDump.label = new char[strlen(buf) + 1];
	    strcpy(codeDump.label, buf);
	    
	    codeDump.instr = NULL;
	    codeDump.comment = NULL;
	    
	    /* An address with a label always have a line for him alone */
	    ret->push_back(codeDump);
	}
	codeDump.label = NULL;
	
	/* Get the instruction */
	asmsprintf(buf, asmfmt, GetAddressObject(c.rva));	
	codeDump.instr = new char[strlen(buf)+1];
	strcpy(codeDump.instr, buf);
	
	/* Get the comment */
	asmsprintf(buf, "%c", GetAddressObject(c.rva));
	if (*buf)
	{
	    codeDump.comment = new char[strlen(buf) + 1];
	    strcpy(codeDump.comment, buf);
	}
	else
	    codeDump.comment = NULL;
	
	/* Add to the vector */
	ret->push_back(codeDump);
	
	if (!bdb_index_next(CODE_RVA, &c)) break;
    }
    
    return ret;
}



BastardFunction *BastardThread::GetFunctionRVA(unsigned int rva)
{
    struct function f;
    BastardFunction *bf;
    char buf[2048];
    
    /* Find the closest previous rva specified and check if the rva is really in the function */
    if (!bdb_index_find(FUNCTION_RVA, &rva, &f))
    {
	if (!bdb_find_closest_prev(FUNCTION_RVA, &rva, &f)) return NULL;
    }
    
    if (f.rva + f.size >= rva) 
    {
	func_get_name(rva, buf);
	    
	bf = new BastardFunction(&f, buf);
	bf->setTargetRVA(rva);
	return bf;
    }

    /* This function returns NULL if rva is not contained in any function */
    return NULL;
}



struct section *BastardThread::GetSectionRVA(unsigned int rva)
{
    struct section *s = new section;
    
    /* Find the closest previous rva specified and check if the rva is really in the section */
    if (bdb_find_closest_prev(SECTION_RVA, &rva, s))
    {
	if (s->rva + s->size >= rva)
	{
	    return s;
	}
    }

    /* This function returns NULL if rva is not contained in any section */
    delete s;
    return NULL;
}


BastardFunction *BastardThread::tryJumpFrom(unsigned int rva)
{
    struct code c;
    
    /* Figure out if the code at rva is a valid jump/call */
    if (bdb_index_find(CODE_RVA, &rva, &c))
    {
	/* TO DO: Figure out what are the meaning of those bits and where they are defined... */
	if (c.mnemType >= 0x1001 && c.mnemType <= 0x1003)
	{
	    return GetFunctionRVA(c.dest);
	}
    }
    
    return NULL;
}


InfoAddr *BastardThread::getInfoAddr(unsigned int rva)
{
    struct address addr;
    BastardFunction *bf;
    struct section *sect;
    char buf[2048];
    
    InfoAddr *infoAddr = new InfoAddr();
    
    infoAddr->setRVA(rva);
    
    if (bdb_index_find(ADDRESS_RVA, &rva, &addr))
    {
	infoAddr->setPA(addr.pa);
	infoAddr->setAddrLen(addr.size);
    }
    
    bf = GetFunctionRVA(rva);
    if (bf)
    {
	infoAddr->setFunctionName(bf->getName());
	delete bf;
    }
    
    sect = GetSectionRVA(rva);
    if (sect)
    {
	infoAddr->setSectionName(sect->name);
	delete sect;
    }
    
    /* TO DO: get this info in a faster way */
    asmsprintf(buf, "%c", GetAddressObject(rva));
    if (*buf) infoAddr->setCodeComment(&buf[1]);
    
    return infoAddr;    
}


void BastardThread::changeCodeComment(unsigned int rva, char *newComment)
{
    struct address a;
    
    if (bdb_index_find(ADDRESS_RVA, &rva, &a))
    {
	if (a.comment)
	{
	    comment_change(a.comment, newComment);
	}
	else
	{
	    a.comment = comment_new(newComment, CMT_USER);
	    bdb_record_update(ADDRESS_RVA, &a.rva, &a);
	}	    
    }
}


void BastardThread::SendReply(void *arg, t_BastardMsg msg, unsigned int t)
{
    t_ReplyMsg *reply = new t_ReplyMsg;
    
    reply->msg = msg;
    reply->arg = arg;
    reply->ticketId = t;
    
    QCustomEvent *ev = new QCustomEvent(12346);
    ev->setData(reply);
    QThread::postEvent(receiver, ev);
}
