#ifndef __BASTARDFUNCTION__H__
#define __BASTARDFUNCTION__H__

#include <stream.h>

extern "C" {
#include <bastard.h>
}

class BastardFunction //: public QObject
{
    public:
    
    BastardFunction(struct function *f, char *n = NULL);
    BastardFunction(BastardFunction *f);
    ~BastardFunction();
    
    unsigned long getId(void)		{ return func.id;		}
    unsigned long getRVA(void)		{ return func.rva;		}
    unsigned short getSize(void)		{ return func.size;	}
    unsigned long getRetType(void)	{ return func.ret_type;	}
    unsigned long getCommentId(void)	{ return func.comment;	}
    
    /* Added function to get extra info */
    char *getName(void)			{ return name;		}
    unsigned int getTargetRVA(void)	{ return targetRVA;	}
    
    void setTargetRVA(unsigned int rva)	{ targetRVA = rva;	}
    
    protected:
    struct function func;
    
    /* Added data */
    char *name;
    unsigned int targetRVA;
    
    
    public:
    
    bool operator == (class BastardFunction *f)	{ return (func.rva == f->func.rva); }
};

#endif
