#ifndef __QHEXEDITWIDGET_H__
#define __QHEXEDITWIDGET_H__

#include <qframe.h>
#include <qevent.h>
#include <qscrollbar.h>
#include <qfont.h>
#include <qpixmap.h>
#include <list>

class QHexEditWidget : public QWidget
{
    Q_OBJECT
    
    public:
    
    QHexEditWidget(QWidget *parent, const char *name = 0);
    QHexEditWidget(QScrollBar *v, QScrollBar *h, QWidget *parent, const char *name = 0);  
    
    virtual void paintEvent(QPaintEvent *);
    virtual void resizeEvent(QResizeEvent *);
    virtual void wheelEvent(QWheelEvent *);
    virtual void mouseReleaseEvent(QMouseEvent *);
    
    void blockPaintEvent(bool v);
    
    void setSource(void *, unsigned int, unsigned int);
    
    unsigned int addHighlight(unsigned int from, unsigned int to, QColor color, RasterOp rop);
    void removeHighlight(unsigned int no);
    
    void jumpTo(unsigned int);
    
    
    signals:
    void leftClick(unsigned int at);
    
    
    protected:
    unsigned char *source;
    unsigned int sourceLen;
    unsigned int baseAddr;
    
    int nbLine;    /* The number of line the dump will generate */
    int fontWidth, fontHeight;
    
    QScrollBar *vScroll;
    QScrollBar *hScroll;
    
    int x, y, maxX, maxY;
    
    QFont font;
    
    QPixmap fontCacheBlack[256];
    QPixmap fontCacheBlue[256];
    
    struct t_HighlightBlock
    {
	unsigned int no;
	unsigned int start;
	unsigned int end;
	QColor color;
	RasterOp rop;		// use Qt::OrNotROP if the color is dark
	                                    // use Qt::AndROP otherwise
    };    
    list<t_HighlightBlock> hiList;
    unsigned int nextHiNo;		// Defines the next no to be given to a addHightlight call
    
    
    public slots:
    void scrollChanged(int);
	    
    
    private:
    void init(void);
    
    void calcDisplayNeed(void);
    void adjustScrollBar(void);
    void updateFontCache(void);
    
    void validateY(void);
    
    bool needRedraw;	// Set to true when a call to paintEvent is done when blockPaintEvent(true) is active
    bool blockRedraw;
};

#endif
