#ifndef __QHEXEDIT_H__
#define __QHEXEDIT_H__

#include <qwidget.h>
#include <qlayout.h>
#include <qscrollbar.h>

#include "qhexeditwidget.h"

class QHexEdit : public QWidget
{
    Q_OBJECT
    
    public:
    
    QHexEdit(QWidget *parent, const char *name = 0);
    
    void setSource(void *s, unsigned int l, unsigned int a) { hexWidget->setSource(s,l,a); }
    unsigned int addHighlight(unsigned int from, unsigned int to, QColor color, RasterOp rop)
    { return hexWidget->addHighlight(from, to, color, rop); }
    void removeHighlight(unsigned int no) { hexWidget->removeHighlight(no); }
    void jumpTo(unsigned int to) { hexWidget->jumpTo(to); }
    void blockPaintEvent(bool v) { hexWidget->blockPaintEvent(v); }
    
    
    public slots:
    void genLeftClick(unsigned int at);
        
    signals:
    void leftClick(unsigned int at, QHexEdit *who);
    
    
    protected:
    QGridLayout *grid;
    QHexEditWidget *hexWidget;
    QScrollBar *vScroll, *hScroll;
};

#endif
