#include "qhexedit.h"

QHexEdit::QHexEdit(QWidget *parent, const char *name = 0) : QWidget(parent, name)
{
    /* Create the layout, all the widget and add them into the layout */
    grid = new QGridLayout(this, 2, 2);
    
    vScroll = new QScrollBar(Qt::Vertical, this);
    hScroll = new QScrollBar(Qt::Horizontal, this);
    
    hexWidget = new QHexEditWidget(vScroll, hScroll, this);
    
    grid->addWidget(hexWidget,0,0);
    grid->addWidget(vScroll,0,1);
    grid->addWidget(hScroll,1,0);
    
    /* This code make sure that the hexWidget get all the space of the layout if one or both
       scroll bar are hide() */
    grid->setColStretch(0,1);
    grid->setColStretch(1,0);
    grid->setRowStretch(0,1);
    grid->setRowStretch(1,0);
    
    connect(hexWidget, SIGNAL(leftClick(unsigned int)), this, SLOT(genLeftClick(unsigned int)));
}


void QHexEdit::genLeftClick(unsigned int at)
{
    emit leftClick(at, this);
}
