#ifndef __QASMEDITWIDGET_H__
#define __QASMEDITWIDGET_H__

#include <qtextedit.h>
#include <qpixmap.h>

#include <vector>

#include "bastardobject.h"


class QAsmEditWidget : public QFrame
{
    Q_OBJECT
    
    public:
    
    QAsmEditWidget(BastardObject *bo, QWidget *parent, const char *name = 0);
    QAsmEditWidget(BastardObject *bo, QScrollBar *v, QScrollBar *h, QWidget *parent, const char *name = 0);
    ~QAsmEditWidget();
    
    QPixmap QAsmEditWidget::lookupPixmap ( const QString name );
    
    void init(void);
    void deleteSrc(void);
    
    virtual void paintEvent(QPaintEvent *);
    virtual void resizeEvent(QResizeEvent *);
    virtual void wheelEvent(QWheelEvent *);
    virtual void mouseReleaseEvent(QMouseEvent *);
    
    void setSourceSection(struct section *);
    void setSourceFunction(BastardFunction *f);
    
    void setArrow(unsigned int rva);
   
    void setHighlight(unsigned int rva);
    unsigned int getHighlight(void) { return highlightRVA; }
    
    void jumpTo(unsigned int RVA);
    
    
    public slots:
    void slotTicketRecv(unsigned int id, void *msg);
    void scrollChanged(int);
    void commentChanged(unsigned int, char *);
    
    
    signals:
    void clickOnRVA(unsigned int, ButtonState);
	    
    
    private:
    BastardObject *bastard;
    
    unsigned int setSourceTicketId;
    
    void displaySource(vector<t_CodeDump> *c);

    vector<t_CodeDump> *src;
    int maxLenInstr;
    int maxLenComment;
    
    int arrow;
    unsigned int arrowRVA;
    bool needUpdateArrow;
    
    int highlight;
    unsigned int highlightRVA;
    bool needUpdateHighlight;
    
    unsigned int jumpToRVA;
    bool needUpdateJumpTo;
    
    QPixmap fontCacheBlack[256];
    QPixmap arrowPixmap;
    
    void updateFontCache(void);
    void calcDisplayNeed(void);
    void adjustScrollBar(void);
    void drawString(QPixmap *pm, int deviceX, int deviceY, char *s, int maxLen);
    void validateY(void);
    
    int fontWidth, fontHeight;
    
    QScrollBar *vScroll;
    QScrollBar *hScroll;
    
    int x, y, maxX, maxY;
    
    QFont font;
};

#endif
