#ifndef __QASMEDIT_H__
#define __QASMEDIT_H__

#include <qwidget.h>
#include <qlayout.h>
#include <qscrollbar.h>

#include "qasmeditwidget.h"

class QAsmEdit : public QWidget
{
    Q_OBJECT
    
    public:
     
    QAsmEdit(BastardObject *bo, QWidget *parent, const char *name = 0);
    
    void setSourceSection(section *s) { asmWidget->setSourceSection(s); }
    void setSourceFunction(BastardFunction *f) { asmWidget->setSourceFunction(f); }
    
    void setArrow(unsigned int rva) { asmWidget->setArrow(rva); }
    
    void setHighlight(unsigned int rva) { asmWidget->setHighlight(rva); }
    unsigned int getHighlight(void) { return asmWidget->getHighlight(); }
    
    void jumpTo(unsigned int rva) { asmWidget->jumpTo(rva); }

    
    public slots:
    void genClickOnRVA(unsigned int, ButtonState);
    
    signals:
    void clickOnRVA(unsigned int, ButtonState);
    
    
    
    
    protected:
    QGridLayout *grid;
    QAsmEditWidget *asmWidget;
    QScrollBar *vScroll, *hScroll;
};

#endif
