#include "qasmedit.h"

QAsmEdit::QAsmEdit(BastardObject *bo, QWidget *parent, const char *name = 0) : QWidget(parent, name)
{
    /* Create the layout, all the widget and add them into the layout */
    grid = new QGridLayout(this, 2, 2);
    
    vScroll = new QScrollBar(Qt::Vertical, this);
    hScroll = new QScrollBar(Qt::Horizontal, this);
    
    asmWidget = new QAsmEditWidget(bo, vScroll, hScroll, this);
    
    grid->addWidget(asmWidget,0,0);
    grid->addWidget(vScroll,0,1);
    grid->addWidget(hScroll,1,0);
    
    /* This code make sure that the asmWidget get all the space of the layout if one or both
       scroll bar are hide() */
    grid->setColStretch(0,1);
    grid->setColStretch(1,0);
    grid->setRowStretch(0,1);
    grid->setRowStretch(1,0);
    
    connect(asmWidget, SIGNAL(clickOnRVA(unsigned int, ButtonState)), this, SLOT(genClickOnRVA(unsigned int, ButtonState)));
}


void QAsmEdit::genClickOnRVA(unsigned int rva, ButtonState bs)
{
    emit clickOnRVA(rva, bs);
}
