#ifndef LIB_SIGNATURES_H
#define LIB_SIGNATURES_H

#include <bastard.h>
#include <bdb.h>
#include <extension.h>

/* one of these has to be passed as 'param' during plugin_main */
/* default is SIG_VAN_EMMERIK */
/* Van Emmerik 'wildcard byte' method */
#define SIG_VAN_EMMERIK		0x01
/* Van Emmerik method, following calls */
#define SIG_VAN_EM_CALL		0x02
/* MD5 sum of invariant bytes */
#define SIG_MD5			0x03
/* comparison of INSN types and operand types */
#define SIG_INSN_TYPES		0x04

#define SIGN_MAGIC      "bSIG"
#define SIGN_VER        1.00
#define SIGN_MAX        128
#define SIGN_MIN        16

/* forward decl */
struct SIGN_SYM_STRUCT;

typedef struct SIGN_LIB_STRUCT {
	const char *name;
	const char *vendor;			/* e.g. GNU, Borland */
	float       version;			/* version num */
	const char *model;			/* e.g. memory model */
	const char *comp;				/* compiler */
	const char *lang;				/* language ext */
	const char *os;				/* os ext */
	const char *arch;				/* CPU arch ext */
	const char *comment;
	struct SIGN_SYM_STRUCT	*entry;	/* signature of entry point [libc] */
	struct SIGN_LIB_STRUCT  *next;
} sign_lib_t;

#define SIGN_MAX		128	/* max signature len */
typedef struct SIGN_SYM_STRUCT {
	sign_lib_t *lib;
	char *name;	
	char *ret;
	char *args;
	char *comment;
	unsigned int sig_len;
	unsigned char *sig;
} sign_sym_t;

/* generate signature for function */
//sign_sym_t * sign_gen_func( sign_lib_t *lib, struct function *func, char *name );
/* generate signatures for all functions in target */
/* entry_sym is the name of the program entry template, e.g. _start */
int sign_gen_target( char *entry_sym );
/* create .sig file for sign tree */
int sign_write_file( FILE *f );
int sign_load_file( FILE *f );
/* match bytes in buf with a signature, fill sym with results */
//sign_sym_t * sign_match_bytes( void *tree, unsigned char *buf, int buf_len );
int sign_match_func( struct function *func );
int sign_match_sec(  struct section *sec );

#endif
