#ifndef LIB_SIGNTREE_H
#define LIB_SIGNTREE_H

#include "signatures.h"

#define SIGN_TREE_NODE	0x01
#define SIGN_TREE_LEAF	0x02

typedef struct SIGNTREE_NODE {
	char type;				/* leaf or node ? */
	short len;
	unsigned char *data;
	struct SIGNTREE_NODE *left, *mid, *right;
} sign_node_t;

typedef struct SIGNTREE_LEAF {
	char type;				/* leaf or node ? */
	short len;
	sign_sym_t *sym;
} sign_leaf_t;

typedef struct SIGNTREE {
	unsigned char	type;			/* algorithm */
	unsigned char 	wc;			/* wildcard */
	short 		pad;
	sign_lib_t		*libs;			/* list of libraries */
	sign_node_t 	*root;			/* trees symbols */
} sign_tree_t;

/* returns a tree structure. 'type' is algorithm from signatures.h,
 * 'wc' is wildcard byte used in sig */
void * sign_tree_new( char type, char wc );
/* free a tree created with tree_new() */
int sign_tree_free( void *tree );
/* insert a 'sym' into signature tree. Note that sym must be allocated
 * by the caller as it will not be copied by sigtree */
int sign_tree_ins( void *tree, sign_sym_t *sym );
/* return sym matching 'buf' in tree or NULL if no match */
sign_sym_t * sign_tree_match( void *tree, unsigned char *buf, int len );
/* get entry point for this library */
sign_sym_t * sign_tree_sym_entry( void *tree );
/* add a library to the tree def */
sign_lib_t * sign_tree_add_lib( void *tree, sign_lib_t *lib );
/* debug routine to print tree to stdout */
int sign_tree_print( void *tree, FILE *file );
#endif

