#include <bastard.h>
#include <bdb.h>
#include <extension.h>

#define SECLINE "-------------------------------------------------------------------------\n"

/* OUTPUT LST: Save disassembled listing of target */
int plugin_main( FILE *f ) {
	char *line;
	int cont;
	struct address addr;
	struct section sec;
	void * state_a,  *state_b;
	struct DISASM_TGT *target = env_get_target();
	struct DISASM_ENV *disasm_env = env_get_env();

	if (!f)
		return (sys_set_lasterr(9030));
	if (!(line = calloc(2048, 1)))
		return (sys_set_lasterr(9050));

	fprintf(f, "Disassembly of %s by the bastard\n\n", target->info.name);
	if(  target->info.header ) fprintf(f, "%s", target->info.header);

	cont = bdb_index_first(SECTION_RVA, &sec);
	while (cont) {
		state_a = db_save_state();
		cont = bdb_find_closest_next(ADDRESS_RVA, &sec.rva, &addr);
		if ( cont ) {
			fprintf(f, "Section: %s\tStart Address: %08X\t"
				   "End Address: %08X\n", sec.name, sec.rva,
				sec.rva + sec.size);
			fprintf(f, SECLINE);
			while (cont && addr.rva < sec.rva + sec.size) {
				state_b = db_save_state();
				ext_sprint_code(addr.rva, line, 2048,
						disasm_env->output);
				db_restore_state(state_b);
				fprintf(f, "%s\n", line);
				line[0] = '\0';
				cont = bdb_index_next(ADDRESS_RVA, &addr);
			}
			fprintf(f, "\n\n");
		}
		db_restore_state(state_a);
		cont = bdb_index_next(SECTION_RVA, &sec);
	}
	free(line);
	return (1);
}
