#include <bastard.h>
#include <bdb.h>
#include <extension.h>


int disasm_do_rest_of_code(){
	/* The purpose of this is to try disassembling all addresses in the code 
	 * section that disasm_forward may have missed. This is not always the 
	 * right thing to do... */
	int cont;
	unsigned long hdr_start;
	struct section s, hdr = {0};
	struct address a = {0};
	struct code c;
	void *state1, *state2;

	sys_msg("Disassembling remainder of code section. Sections:\n");
	/* get header section for later reference */
	bdb_index_find(SECTION_NAME, "header", &hdr );
	bdb_index_find(ADDRESS_RVA, &hdr.rva, &a);
	hdr_start = a.pa;

	cont = bdb_index_first( SECTION_RVA, &s);
	while( cont) {
		state1 = db_save_state();
		if ( (s.flags & SECTION_EXECUTE) || (s.flags & SECTION_TYPE_MASK) == SECTION_CODE ) {
			sys_visual("(");
			sys_visual(s.name);
			sys_visual(")");
			sys_visual("|");
			/* foreach address in section */
			cont = bdb_index_find(ADDRESS_RVA, &s.rva, &a);
			/* if this is also the header section, skip it*/
			if ( a.pa >= hdr_start && a.pa < hdr_start + hdr.size ){
				a.rva += (hdr_start + hdr.size) - a.pa;
				cont = bdb_index_find(ADDRESS_RVA, &a.rva, &a);
			}
			while ( cont && a.rva < s.rva + s.size ) {
				sys_visual("\b/");
				bdb_find_closest_next(CODE_RVA, &a.rva, &c );
				sys_visual("\b-");
				if ( c.rva > a.rva + 4) {	/* 4: from my ass to this code */
					/* if there is no code record, try to disasm */
					disasm_forward( a.rva );
					sys_visual("\b\\");
				}
				sys_visual("\b|");
				bdb_index_find(ADDRESS_RVA, &a.rva, &a);
				cont = bdb_index_next(ADDRESS_RVA, &a);
			}
		}
		sys_visual("-");
		db_restore_state( state1 );
		cont = bdb_index_next( SECTION_RVA, &s );
	}
	sys_visual("\n");
}

int plugin_main(void *param)
{
	struct DISASM_TGT *target;
	struct function f;
	void *state;
	int cont;

	target = env_get_target();


	/* first, make sure all C data types are loaded */
	ext_add_data_types( disasm_word_size() );
	/* PREDISASM phase: parse the file header */
	if (! (target->status & DISASM_TGT_PREDISASM) )
		if (!target_apply_format())
			return (sys_set_lasterr(4570));
	target->status |= DISASM_TGT_PREDISASM;

	/* DISASM phase */
	/* Start by disassembling all functions recognized by the format parser */
	sys_msg("Disassembling named symbols. Instruction stack:\n");

	cont = bdb_index_first(FUNCTION_RVA, &f);
	while (cont) {
		state = db_save_state();
		disasm_forward(f.rva);
		db_restore_state( state );
		cont = bdb_index_next(FUNCTION_RVA, &f);
	}

	/* Then attack the entry point */
	if (target->info.entry == 0xFFFFFFFF) {
		sys_msg("No entry point in target.\n");
	} else {
		sys_msg("Disassembling forward from entry point. "
			  "Instruction stack:\n");
		disasm_forward(target->info.entry);
		/* create an export and a function for the entry point */
		exp_new(target->info.entry, "_start");
		func_new(target->info.entry, "_start", 1, 0);
	}
	disasm_do_rest_of_code();
	target->status |= DISASM_TGT_DISASM;

	/* POSTDISASM Phase */
	sys_msg("Performing post-disassembly passes\n");
	target->status |= DISASM_TGT_POSTDISASM;

	/* All clear, return to base */
	return (1);
}
