#include <bastard.h>
#include <bdb.h>
#include <extension.h>



int plugin_main(void *param)
{
	struct DISASM_TGT *target;
	char str[256];
	struct section s;
	int cont;

	target = env_get_target();

	ext_add_data_types( disasm_word_size() );
	/* PREDISASM phase: parse the file header */
	if (! (target->status & DISASM_TGT_PREDISASM))
		if (!target_apply_format())
			return (sys_set_lasterr(4570));
	/* Calling EiC from withing EiC really fucks the stack over */
	target->status |= DISASM_TGT_PREDISASM;


	/* DISASM phase */
	cont = bdb_index_first(SECTION_RVA, &s);
	while (cont) {
		if ((s.flags & SECTION_TYPE_MASK == SECTION_CODE) ||
		    s.flags & SECTION_EXECUTE) {
			sprintf(str,
				"Disassembling Section %s . Instruction stack:\n",
				s.name);
			sys_msg(str);
			disasm_section(s.name);
		}
		cont = bdb_index_next(SECTION_RVA, &s);
	}
	target->status |= DISASM_TGT_DISASM;

	/* POSTDISASM Phase */
	/* create an export for the entry point */
	exp_new(target->info.entry, "_start");
	target->status |= DISASM_TGT_POSTDISASM;

	sys_msg("Done.\n");
	return (1);
}
