#include <stdio.h>
#include <stdlib.h>

#include <bastard.h>
#include <extension.h>
#include <vm.h>

#include "linux.h"
#include "linux.tables.h"


#define MAX_SYSCALL_BACKTRACK 20	/* 20 instructions should be sufficient ;) */
struct EXT__OS *settings;	/* might come in handy */

void ext_os_init(void *param)
{
	settings = (struct EXT__OS *) param;

	if (!settings)
		return;

	settings->type = 
		OS_MONOLITHIC | OS_MULTITASK | OS_POSIX | OS_SYSV | OS_BSD;
	settings->syscall_param_type = SYSCALL_PARAM_REG;
	settings->syscall_max_params = 5;
	settings->device_id_type = OS_DEVICE_ID_STRING;
/* system startup state:
 * EAX	:	0x0
 * EBX	:	0x0
 * ECX	:	0x0
 * EDX	:	0x0
 * ESI	:	0x0
 * EDI	:	0x0
 * EBP	:	0x0
 * ESP	:	0xBFFFFB40
 * EFLAGS	:	0x292
 * CS	:	0x23
 * DS	:	0x2B
 * ES	:	0x2B
 * FS	:	0x0
 * GS	:	0x0
 * SS	:	0x2B
 */

	return;
}

void ext_os_cleanup(void)
{
	return;
}

/* yes, linux runs on many platforms, buit we deal with intel here ;) */
int os_syscall_gen_intel(struct code *c, struct sysref *s){
	int num = 0, cont, reg;
	struct VM_DATA reg_contents;
	struct code code;
	void *state;

	state = db_save_state();
	reg = vm_get_reg_byname("eax");

	cont = bdb_find_closest_prev( CODE_RVA, &c->rva, &code );
	while ( cont  && code.rva >= MAX_SYSCALL_BACKTRACK ) {
		/* yes, MAX_SYSCALL_BACKTRACK is a hack, deal with it */
		/* find last setting of eax */
		if ( (code.destType & OP_TYPE_MASK) == OP_REG && 
		     (code.destType &  OP_W) && code.dest == reg ) {
			cont = 0;	/* eax gets overwritten here */

			if ( (code.srcType & OP_TYPE_MASK) == OP_IMM && 
				code.src > 0 && code.src < SYSCALL_MAX ) {
				/* cool, this sets eax directly */
				num = code.src;
			} else {
				/* try to get contents of eax from VM */
				if (vm_read_reg( reg, &reg_contents )) {
					num = reg_contents.u.i;
				} /* else num == 0; we failed */
			}
		} else  {
			cont = bdb_index_prev(CODE_RVA, &code );
		}
	}

	if ( num > 0 && num < SYSCALL_MAX ){ 
		s->ref = num;
		s->subtype = syscall_table[num].type;
		s->type = SYSREF_SYSCALL;
		s->rva = c->rva;
	}
	
	db_restore_state( state );
	return( num );
}

int os_sysref_gen(struct code *c, struct sysref *s){
	const char *cpu = target_arch();

	if ( ! strcmp( cpu, "i386" ) ) {
		switch (c->mnemType & INS_TYPE_MASK) {
			case INS_TRAPCC:
			case INS_TRAP:
				if ( ! strcmp( c->mnemonic, "int") ) {
					if ( (c->destType & OP_TYPE_MASK) == OP_IMM &&
						c->dest == 0x80 ) {
						/* we have a syscall */
						return( os_syscall_gen_intel(c,s) );
					}
					/* else handle other int instructions */
				} /* handle other trap insns? */
				break;
			case INS_BOUNDS:
			case INS_DEBUG:
			case INS_TRACE:
			case INS_INVALIDOP:
			case INS_OFLOW:
				/* handle exceptions */
				break;
			default:
				/* check for device files */
				break;
		} 
	}
	return(0);
}

int os_sysref_name(struct sysref *s, char *buf, int len) {
	if (! buf) return(0);
	buf[0] = '\0';

	switch ( s->type ) {
		case SYSREF_SYSCALL:
			if ( s->ref > 0 && s->ref < SYSCALL_MAX) 
				strncpy( buf, syscall_table[s->ref].name, len );
			break;
		case SYSREF_EXCEPTION:
		case SYSREF_TRAP:
		case SYSREF_DEVICE:
		default:
			break;
	}
	return(strlen(buf));
}
