#include "db_bsql.h"

extern struct BSQL_SETTINGS *bsql_settings;



struct BSQL_TMPTBL * bsql_tmptbl_create( struct BSQL_COL *columns){
	struct BSQL_TMPTBL *t;
	struct BSQL_COL *c, col_list, *new;
	int row_size, offset = 0; size = 0;

	if (! columns) 	return(NULL);
	t = calloc( sizeof(struct BSQL_TMPTBL), 1);
	c = columns;
	new = &col_list;
	while ( c ) {
		new->next = calloc( sizeof(struct BSQL_TMPTBL), 1 );
		if (! new ) break;
		new = new->next;
		/* add size of the last one to offset */
		offset += size;
		/* figure out size of this one */
		size = c->size * db_type_sizeof(c->type);
		memcpy( new, c, sizeof(struct BSQL_TMPTBL) );
		/* clear inapplicable stuff from new column */
		new->offset = offset;
		new->table = (int) t;
		new->index = 0;
		new->next = NULL;
		/* the good stuff */
		c = c->next;
	}
	t->columns = col_list->next;
	t->row_size = offset + size;	

	return(t);
}

struct BSQL_COL * bsql_cols_from_dbtable( struct db_field *f ) {
	struct BSQL_COL *col, col_list = {0};

	col = &col_list;
	while ( f ) {
		col->next = calloc( sizeof(struct BSQL_COL), 1 );
		if ( col->next ) {
			col = col->next;
			col->name = f->name;
			col->size = f->size;
			col->type = f->type;
			col->offset = f->offset;
		}
		f = f->next;
	}
	return( col_list.next );
}
int bsql_collist_free( struct BSQL_COL *columns ) {
	struct BSQL_COL *c;

	while ( columns ) {
		c = columns;
		columns = columns->next;
		free(c);
	}
	return( 1 );
}

int bsql_rowlist_free( struct BSQL_ROW *rows ) {
	struct BSQL_ROW *r;

	while ( rows ) {
		r = rows;
		rows = rows->next;
		free( r->data );
		free( r );
	}
	return(1);
}

int bsql_tmptbl_destroy( struct BSQL_TMPTBL *table) {
	if (! table ) return(0);
	bsql_collist_free( table->columns );
	bsql_rowlist_free( table->rows );
	free( table );
	return(1);
}

int bsql_tmptbl_add( struct BSQL_TMPTBL *t, char *row ){
	struct BSQL_ROW *r;

	if (! t || ! row ) 	return(0);
	
	r = calloc( sizeof( struct BSQL_ROW ), 1 );
	if (! r)	return(0);
	
	/* copy row data into row structure */
	r->data = calloc( t->row_size, 1 );
	if (! r->data ) 	{
		free(r);
		return(0);
	}
	memcpy( r->data, row, t->row_size );

	/* set last row to this one */
	if (! t->rows ) {
		t->rows = t->last = r;
		t->current = r;
	} else {
		t->last->next = r;
		r->prev = t->last;
		t->last = r;
	}
	return(1);
}
		
	
char * bsql_tmptbl_first( struct BSQL_TMPTBL *t) {
	if (! t || ! t->rows)	return(NULL);
	return( t->rows->data );
}

char * bsql_tmptbl_next( struct BSQL_TMPTBL *t){
	if (! t || ! t->current || ! t->current->next)	return(NULL);
	return( t->current->next->data );
}

char * bsql_tmptbl_prev( struct BSQL_TMPTBL *t){
	if (! t || ! t->current || ! t->current->prev )	return(NULL);
	return( t->current->prev->data );
}

char * bsql_tmptbl_last( struct BSQL_TMPTBL *t){
	if (! t || ! t->last)	return(NULL);
	return( t->last->data );
}



int bsql_tmptbl_foreach( struct BSQL_TMPTBL *t, BSQL_ROW_FN fn, void *arg ){
	struct BSQL_ROW *row;

	if (! t || !fn ) 	return(0);

	row = t->rows;
	while ( row ) {
		(*fn)( t, row->data, arg );
		row = row->next;
	}
	return(1);
}

void bsql_tmptbl_sprintrow( struct BSQL_TMPTBL *t, char *row, char *buf ) {
	struct BSQL_COL *c;
	char tmp[512];
	int max;

	if (! t || !row || ! buf) return(0);
	c = t->columns;
	max = t->row_size * 4;
	while ( c ) {
		memset( tmp, 0, 512);
		sprint_field_value(tmp, 512, c->type, row + c->offset, c->size);
		strncat( buf, tmp, max );
		c = c->next;
		if ( c )
			strcat( buf, bsql_settings->field_delim );
	}
	strcat( buf, bsql_settings->record_delim );
	return;
}


char * bsql_tmptbl_tostr( struct BSQL_TMPTBL *t ) {
	/* assume strings will be about 4x the length of the rec */
	int str_size;
	char *buf;
	
	if (! t ) return(NULL);
	str_size = t->row_size * 4;
	buf = calloc( str_size, t->num_rows );
	if (! buf ) return(NULL);

	bsql_tmptbl_foreach( t, bsql_tmptbl_sprintrow, buf );

	return(buf);
}

/* This copys the rows from t_old to t_new, using only the fields specified in
 * t_new */
int bsql_tmbtbl_convert( struct BSQL_TMPTBL *t_old, struct BSQL_TMPTBL *t_new ){
	struct BSQL_ROW *old_row;
	struct BSQL_COL *old_col, *new_col;
	char *new_row;

	if (! t_old || ! t_new) 	return( 0 );
	new_row = calloc( t_new->row_size, 1 );
	if (! new_row) 	return(0);

	/* foreach row in old  */
	old_row = t_old->rows;
	while ( old_row ) {		/* yeah, this is fucking lame, sowot? */
		/* foreach col in old */
		old_col = t_old->columns;
		while ( old_col ) {
			new_col = t_new->columns;
			/* if col is in new, add col to new_row */
			while ( new_col ) {
				if ( ! strcmp( new_col->name, old_col->name ) ) {
					db_set_field_in_rec( new_col, new_row, 
								&old_row[old_col->offset] );
				}
				new_col = new_col->next;
			}
			old_col = old_col->next;
		}
		/* add new_row to new */
		bsql_tmptbl_add( t_new, new_row );
		old_row = old_row->next;
	}
	free( new_row );
	return(1);
}



/* ---------------------------------------------- support routines */
struct BSQL_COL * bsql_tmptbl_colmerge( struct BSQL_TMPTBL *t1, 
						struct BSQL_TMPTBL *t2){
	struct BSQL_COL *c1, *c2, col_list, *col;
	int add;

	if (! t1 || !t2 ) return(NULL);
	c1 = t1->columns;
	c2 = t2->columns;
	if (! c1 || ! c2 ) return(NULL);

	col = &col_list;
	while ( c1 ) {
		col->next = calloc( sizeof(struct BSQL_COL), 1);
		if (! col->next ) break;
		col = col->next;
		memcpy( col, c1, sizeof(struct BSQL_COL));
		c1 = c1->next;
	}

	while ( c2 ) {
		add = 1;
		c1 = t1->columns;
		while ( c1 ) {
			if ( ! strcmp( c1->name, c2->name ) ) {
				add = 0;
				break;
			}
			c1 = c1->next;
		}
		if ( add ) {
			col->next = calloc( sizeof(struct BSQL_COL), 1);
			if (! col->next ) break;
			col = col->next;
			memcpy( col, c2, sizeof(struct BSQL_COL));
		}
		c2 = c2->next;
	}
	return( col_list->next );
}

char * bsql_row_merge( struct BSQL_TMPTBL *t1, struct BSQL_ROW *r1, 
					struct BSQL_TMPTBL *t2, struct BSQL_ROW *r2 ){
	char *buf, *pos;
	struct BSQL_COL *c, *taken;
	int size, add;

	if (! t1 || ! t2 || ! r1 || ! r2 ) 
		return(NULL);
	/* 'buf' will be a little oversized, but not much */
	buf = calloc( (t1->num_rows * t1->row_size) + 
			  (t2->num_rows * t2->row_size), 1 );
	if (! buf ) return(NULL);

	pos = buf;
	/* add all the fields from table 1 */
	c = t1->columns;
	while ( c ) {
		size = c->size * db_type_sizeof( c->type );
		memcpy( pos, r1[c->offset], size );
		pos += size;
		c = c->next;
	}

	/* add the unique fields from table 2 */
	c = t2->columns;
	while ( c ) {
		add = 1;
		taken = t1->columns;
		while ( taken ) {
			if (! strcmp( c->name, taken->name ) ) {
				add = 0;
				break;
			}
			taken = taken->next;
		}
		if ( add ) {
			size = c->size * db_type_sizeof( c->type );
			memcpy( pos, r2[c->offset], size );
			pos += size;
		}
		c = c->next;
	}
	return(buf);
}

int bsql_row_assign( char *src, struct BSQL_COL *src_col, char *dest, 
				struct BSQL_COL *dest_col ){
	struct BSQL_COL *sc, *dc;
	int szs, szd;	/* size of src and dest fields */

	if (! src || ! src_col || ! dest || !dest_col )	return(0);

	/* for each src_col */
	sc = src_col;
	while ( sc ) {
		dc = dest_col;
		while ( dc ) {
			/* find dest_col with same name */
			if (! strcmp( sc->name, dc->name ) ) {
				/* copy data from src[srccol->offset] to dest[...] */
				szs = sc->size * db_type_sizeof(sc->type);
				szd = dc->size * db_type_sizeof(dc->type);
				if ( szs <= szd ) {
					memcpy(&dest[dc->offset], &src[sc->offset], szs);
				}
			}
			dc = dc->next;
		}
		sc = sc->next;
	}
	return( 1 );
}

int bsql_tmptbl_keyoffset( struct BSQL_TMPTBL *t, char *keyname ) {
	struct BSQL_COL *col;

	/* get offset of primary key within record */
	col = t->columns;
	while ( col ) {
		if (! strcmp( col->name, keyname) ) {
			return( col->offset );
			break;
		}
		col = col->next;
	}
	return(0);
}

