%{
#include "db_bsql.h"

struct ASGNPAIR {
	struct TREELEAF	*col;		/* VALREF */
	struct TREENODE   *value;	/* any scalar: MATHOP or VALREF */
};

struct TABLEEXPR {
	struct TREENODE	*from;
	struct TREENODE	*where;
	struct TREENODE	*groupby;
	struct TREENODE	*having;
};

%}

%union {
	int ival;
	double fval;
	char *strval;
	int subtok;
	struct ASGNPAIR	*asgnpr;
	struct TABLEEXPR	*tblexp;
	struct TREENODE 	*node;
	struct TREELEAF 	*leaf;
}


%token NAME
%token STRING
%token INTNUM APPROXNUM HEXNUM BINNUM

%left COMPARISON 
%left OR AND NOT
%left '+' '-'
%left '*' '/'
%nonassoc UMINUS

%token ALL ANY ASC AVG MIN MAX SUM COUNT AS BETWEEN BY CLOSE CONTINUE
%token CURRENT CURSOR DECIMAL DECLARE DELETE DESC DISTINCT ESCAPE EXISTS FETCH
%token FOR FOUND FROM FUNC_NAME GROUP HAVING IN INDICATOR INSERT INTO IS LIKE
%token NULLX NUMERIC OF ON OPEN ORDER REFERENCES SELECT SET SOME TABLE TO UNION
%token UNIQUE UPDATE VALUES VIEW WHERE WITH WORK
%token BSQL_BOOL_AND BSQL_BOOL_OR BSQL_BOOL_NOT
%token BSQL_CMP_LT BSQL_CMP_LE BSQL_CMP_EQ BSQL_CMP_GE BSQL_CMP_GT BSQL_CMP_NE
%token BSQL_MATHOP_ADD BSQL_MATHOP_SUB BSQL_MATHOP_MUL BSQL_MATHOP_DIV
%token BSQL_MATHOP_AND BSQL_MATHOP_OR BSQL_MATHOP_XOR

/* types for rules */
%type <tblexp> table_exp
%type <asgnpr> assignment assignment_commalist
%type <node> sql sql_list cursor_def manipulative table
%type <node> search_cond parameter_ref literal
%type <node> subquery existence_test all_or_any_predicate atom_commalist
%type <node> in_predicate test_for_null like_predicate between_predicate
%type <node> comparison_predicate predicate search_condition opt_having_clause
%type <node> column_ref_commalist opt_groupby_clause where_clause
%type <node> table_ref_commalist from_clause query_spec query_term query_exp
%type <node> selection select_statement function_ref scalar_exp_commalist
%type <node> scalar_exp update_statement_searched update_statement_positioned
%type <node> insert_atom_commalist values_or_query_spec insert_statement
%type <node> where_clause opt_where_clause delete_statement_searched
%type <node> delete_statement_positioned manipulative sql
%type <leaf> opt_escape table_ref nullx atom insert_atom column_ref
%type <int> any_all_some opt_all_distinct 



%%

statement:
		sql			{ ;	}
	|	sql_list		{ ;	}
	;

/* sql_list: return a linked list of root nodes? */
sql_list:
		/* empty */ 	{ ; 	}
	|	sql ';' sql_list 	{ ;	}
	;

/* sql: return a root node */
sql:		
		cursor_def 			{ $$ = $1; }
	|	manipulative		{ $$ = $1; }
	;

/* ============================================ C U R S O R    D E F */
/* cursor_def: not impl */
cursor_def:
	DECLARE cursor CURSOR FOR query_exp opt_order_by_clause	{ ; }
	;

/* opt_order_by_clause: not impl */
opt_order_by_clause:
	/* empty */	{ ; }
	|	ORDER BY ordering_spec_list	{ ; }
	;

/* ordering_spec_list: not impl */
ordering_spec_list:
		ordering_spec	{ ; }
	|	ordering_spec_list ',' ordering_spec	{ ; }
	;

/* ordering_spec: not impl */
ordering_spec:
		INTNUM opt_asc_desc		{ ; }/* by col/field # */
	|	column_ref opt_asc_desc			{ ; }/* by col/field name */
	;

/* opt_asc_desc: not impl */
opt_asc_desc:
		/* empty */	{ ; }
	|	ASC	{ ; }
	|	DESC	{ ; }
	;

/* cursor:	not impl */
cursor:	
		NAME	{ ; }
	;

/* column_ref: returns BSQL_VALREF */
column_ref:
		NAME				{ 	/* column name */
			/* how to know table? keep global var? */
		}
	|	NAME '.' NAME		{	/* table.col */
			/* build VALREF for col */
		}
	;

/* ============================================ M A N I P U L A T I V E */

/* manipulative: returns root node */
manipulative:
		close_statement				{ $$ = NULL; }
	|	delete_statement_positioned		{ $$ = NULL; }
	|	delete_statement_searched		{ $$ = $1; }
	|	fetch_statement				{ $$ = NULL; }
	|	insert_statement				{ $$ = $1; }
	|	open_statement				{ $$ = NULL; }
	|	select_statement	{
			/* make BSQL_SELECT from subsel ?? */
		}
	|	update_statement_positioned		{ $$ = NULL; }
	|	update_statement_searched		{ $$ = $1; }
	;

/* open_statement: not impl */
open_statement:
		OPEN cursor	{ ; }
	;

/* close_statement: not impl */
close_statement:
		CLOSE cursor	{ ; }
	;

/* delete_statement_positioned: not impl */
delete_statement_positioned:
		DELETE FROM table WHERE CURRENT OF cursor	{ ; }
	;

/* delete_statement_searched: returns BSQL_DELETE */
delete_statement_searched:
		DELETE FROM table opt_where_clause	{ 
			/* if ! $4 make tbl_cpy node */
			$$ = bsql_new_delete( $3, $4 ); 
		}
	;

/* opt_where_clause returns BSQL_TABLESEL */
opt_where_clause:	
		/* empty */					{ $$ = NULL; }
	|	where_clause				{ $$ = $1 }
	;

/* where_clause returns BSQL_TABLESEL */
where_clause:
		WHERE search_cond				{ $$ = $2 }
	;
		

/* FETCH ----------------------------------------- */
/* fetch_statement: not impl */
fetch_statement:
		FETCH cursor INTO target_commalist	{ ; }
	;

/* target_commalist: not impl */
target_commalist:
		target	{ ; }
	|	target_commalist ',' target	{ ; }
	;

/* target: not impl */
target:
		parameter_ref	{ ; }
	;

/* parameter_ref: not impl */
parameter_ref:
		parameter	{ ; }
	|	parameter parameter	{ ; }
	|	parameter INDICATOR parameter	{ ; }
	;

/* parameter: not impl */
parameter:
		/* empty */	{ ; }
	|	':' NAME 		{ ; }/* embedded parameter */
	;
/* ----------------------------------------- */

/* insert_statement: returns BSQL_INSERT */
insert_statement:
		INSERT INTO table opt_column_commalist values_or_query_spec {	
				/* make comma list */
				/* make asgn list */
				bsql_insert_new( $3, NULL );
		}
	;

/* values_or_query_spec: returns BSQL_ASGN */
values_or_query_spec:
		VALUES '(' insert_atom_commalist ')' {
				/* make ASGN from $3 */
		}
	|	query_spec {
			/* make ASGN from $1 */
		}
	;

/* insert_atom_commalist: returns BSQL_VALLST */
insert_atom_commalist:
		insert_atom	{
			$$ = bsql_new_vallst( NULL, $1 );
		}
	|	insert_atom_commalist ',' insert_atom	{
			$$ = bsql_new_vallst( $1, $3 );
		}
	;

/* insert_atom: returns BSQL_VALREF */
insert_atom:
		atom				{ $$ = $1; }
	|	nullx				{ $$ = $1; }
	;

/* atom: returns BSQL_VALREF */
atom:
		parameter_ref		{ $$ = $1; }
	|	literal			{ $$ = $1; }
	;

/* nullx: returns BSQL_VALREF */
nullx:
		NULLX				{ $$ = bsql_new_lval( 0 ); }
	;
/* ----------------------------------------- */

/* update_statement_positioned: not impl */
update_statement_positioned:
		UPDATE table SET assignment_commalist WHERE CURRENT OF cursor {
			$$ = NULL;
		}
	;
	
/* assignment_commalist: no idea */
assignment_commalist:
		/* empty */	{ ; }
	|	assignment	{
		}
	|	assignment_commalist ',' assignment {
		}
	;

/* assignment: generates asgn_pair? */
assignment:
		column '=' scalar_exp	{  }
	|	column '=' NULLX		{	/* make valref for NULL */ 
						}
	;

/* update_statement_searched: returns BSQL_UPDATE node */
update_statement_searched:
		UPDATE table SET assignment_commalist opt_where_clause {
			/* make new update */
			bsql_new_update( $2, );
		}
	;

/* scalar_exp: returns BSQL_VALREF or BSQL_MATHOP */
scalar_exp:
		scalar_exp '+' scalar_exp 		{
			bsql_new_mathop( $1, $3, BSQL_MATHOP_ADD );
		}
	|	scalar_exp '-' scalar_exp		{
			bsql_new_mathop( $1, $3, BSQL_MATHOP_SUB );
		}
	|	scalar_exp '*' scalar_exp		{
			bsql_new_mathop( $1, $3, BSQL_MATHOP_MUL );
		}
	|	scalar_exp '/' scalar_exp		{
			bsql_new_mathop( $1, $3, BSQL_MATHOP_DIV );
		}
	|	'+' scalar_exp %prec UMINUS		{
			/* bsql_new_mathop( ); */
			$$ = $2;
		}
	|	'-' scalar_exp %prec UMINUS		{
			/* bsql_new_mathop( ); */
			$$ = $2;
		}
	|	atom						{ $$ = $1; }
	|	column_ref					{ $$ = $1; }
	|	function_ref				{ $$ = $1; }
	|	'(' scalar_exp ')'			{ $$ = $2; }
	;

/* scalar_exp_commalist: returns BSQL_COLLST */
scalar_exp_commalist:
		scalar_exp 	{
			/* may have to convert number to column :P */
			$$ = bsql_new_collst( NULL, $1 );
		}
	|	scalar_exp_commalist ',' scalar_exp {
			$$ = bsql_new_collst( $1, $3 );
		}
	;

/* function_ref: does nothing */
function_ref:
		FUNC_NAME  '(' '*' ')'				{ $$ = NULL; } /* COUNT(*) */
	|	FUNC_NAME  '(' DISTINCT column_ref ')'	{ $$ = NULL; }
	|	FUNC_NAME  '(' ALL scalar_exp ')'		{ $$ = NULL; }
	|	FUNC_NAME  '(' scalar_exp ')'		{ $$ = NULL; }
	;
/* ----------------------------------------- */

/* select_statement: returns BSQL_SELECT */
select_statement:
		SELECT opt_all_distinct selection INTO target_commalist table_exp {
				/* opt_all_distinct and target_commalist ignored */
				/* build select based on $3 and $6 */
				$$ = bsql_select_new( , );
			}
	|	query_spec		{ $$ = $1; }
	;

/* opt_all_distinct: does nothing */
opt_all_distinct:
		/* empty */		{ $$ = NULL; }
	|	ALL			{ $$ = NULL; }
	|	DISTINCT		{ $$ = NULL; }
	;

/* selection: returns BSQL_COLLST */
selection:
		scalar_exp_commalist	{ $$ = $1; }
	|	'*' {		
			/* build list of all columns, return column list */
			$$ = NULL;
		}
	;

/* query_exp: returns BSQL_SUBSEL node */
/* NOTE: used ONLY in cursor definition: we can ignore for now */
query_exp:
		query_term						{ $$ = $1; }
	|	query_exp UNION query_term			{
				/* make join ?? */
				$$ = NULL;
			}
	|	query_exp UNION ALL query_term		{
				/* make join ?? */
				$$ = NULL;
			}
	;

/* query_term: returns BSQL_SUBSEL node */
query_term:
		query_spec			{ $$ = $1; }
	|	'(' query_exp ')'		{ $$ = $2; }
	;

/* query_spec: returns BSQL_SELECT struct */
query_spec:
		SELECT opt_all_distinct selection table_exp {
			/* note: this node will be patrsed && deleted by cursor ops */
			$$ = bsql_select_new( , );
		}
	;

/* table_exp: returns TABLEEXP struct for internal parser use */
table_exp:
		from_clause opt_where_clause opt_groupby_clause opt_having_clause	{
			/* build select statement */
			$$.from = $1;
			$$.where = $2;
			$$.groupby = $3;
			$$.having = $4;
		}
	;

/* from_clause: returns BSQL_TBLLST $2 */
from_clause:
		FROM table_ref_commalist	{ $$ = $2; }
	;

/* table_ref_commalist: returns BSQL_TBLLST */
table_ref_commalist:
		table_ref			{
			$$ = bsql_new_tbllst( NULL, $1);
		}
	|	table_ref_commalist ',' table_ref {
			$$ = bsql_new_tbllst( $1, $3 );
		}
	;

/* table_ref: returns BSQL_VALREF $1 */
table_ref:
		table					{ $$ = $1; }
	;

/* where_clause: returns $2 BSQL_BOOL */
where_clause:
		WHERE search_condition		{ $$ = $2; }
	;

/* opt_groupby_clause: returns $3 BSQL_COLLST node */
opt_groupby_clause:
		/* empty */					{ $$ = NULL; }
	|	GROUP BY column_ref_commalist		{ $$ = $3; }
	;

/* column_ref_commalist: returns BSL_COLLST */
column_ref_commalist:
		column_ref					{
			$$ = bsql_new_collst( NULL, $1 );
		}
	|	column_ref_commalist ',' column_ref	{
			$$ = bsql_new_collst( $1, $3 );
		}
	;

/* opt_having_clause: returns $2 BSQL_BOOL node */
opt_having_clause:
		/* empty */				{ $$ = NULL; }
	|	HAVING search_condition		{ $$ = $2; }
	;

/* search_condition: returns BSQL_BOOL node || BSQL_CMP node $1 */
search_condition:
		/* empty */				{ $$ = NULL; }
	|	search_condition OR search_condition	{
			$$ = bsql_new_bool( $1, $3, BSQL_BOOL_OR );
		}
	|	search_condition AND search_condition	{
			$$ = bsql_new_bool( $1, $3, BSQL_BOOL_AND );
		}
	|	NOT search_condition	{
			$$ = bsql_new_bool( NULL, $2, BSQL_BOOL_NOT );
		}
	|	'(' search_condition ')'			{ $$ = $2; }
	|	predicate						{ $$ = $1; }
	;

/* predicate: returns a BSQL_CMP node */
predicate:
		comparison_predicate		{ $$ = $1 }
	|	between_predicate			{ $$ = $1 }
	|	like_predicate			{ $$ = $1 }
	|	test_for_null			{ $$ = $1 }
	|	in_predicate			{ $$ = $1 }
	|	all_or_any_predicate		{ $$ = $1 }
	|	existence_test			{ $$ = $1 }
	;


/* comparison_predicate: returns a BSQL_CMP node for the compare */
comparison_predicate:
		scalar_exp COMPARISON scalar_exp	{
			$$ = bsql_new_cmp( $1, $3, yytext ); 
		}
	|	scalar_exp COMPARISON subquery {
			/* force subquery to return a single col, e.g. a VALREF */
			/* make new cmp with valref */
			$$ = NULL;
		}
	;

/* between_predicate: returns a BSQL_CMP node for the BETWEEN */
between_predicate:
		scalar_exp NOT BETWEEN scalar_exp AND scalar_exp	{ $$ = NULL; }
	|	scalar_exp BETWEEN scalar_exp AND scalar_exp		{ $$ = NULL; }
	;

/* like_predicate: returns a BSQL_CMP node for the LIKE */
like_predicate:
		scalar_exp NOT LIKE atom opt_escape		{ $$ = NULL; }
	|	scalar_exp LIKE atom opt_escape		{ $$ = NULL; }
	;
	
/* doesn't do anything */
opt_escape:
		/* empty */		{ $$ = NULL; }
	|	ESCAPE atom		{ $$ = $2; }
	;

/* test_for_null: returns a BSQL_CMP node for comparinson with 0 */
test_for_null:
		column_ref IS NOT NULLX {
			struct TREELEAF *l = bsql_new_lval( 0 );
			struct TREENODE *n = bsql_new_cmp( $1, l, BSQL_CMP_NE );
			$$ = n;
		}
			
	|	column_ref IS NULLX {
			struct TREELEAF *l = bsql_new_lval( 0 );
			struct TREENODE *n = bsql_new_cmp( $1, l, BSQL_CMP_EQ );
			$$ = n;
		}
	;
		
/* in_predicate: returns a BSQL_CMP node for the 'in' : not impl */
in_predicate:
		scalar_exp NOT IN '(' subquery ')'		{ $$ = NULL; }
	|	scalar_exp IN '(' subquery ')'		{ $$ = NULL; }
	|	scalar_exp NOT IN '(' atom_commalist ')'	{ $$ = NULL; }
	|	scalar_exp IN '(' atom_commalist ')'	{ $$ = NULL; }
	;

/* atom_commalist: returns a BSQL_VALLST node for 'atom' valref */
atom_commalist:
		atom					{
			$$ = bsql_new_vallst( NULL, $1 );
		}
	|	atom_commalist ',' atom		{
			$$ = bsql_new_vallst( $1, $3 );
		}
	;

/* all_or_any_predicate: returns a BSQL_CMP node  */
all_or_any_predicate:
		scalar_exp COMPARISON any_all_some subquery	{
			/* ignore for now */
			$$ = NULL;
		}
	;

/* any_all_some: no idea what to do here :) */
any_all_some:
		ANY		{ $$ = NULL; }
	|	ALL		{ $$ = NULL; }
	|	SOME		{ $$ = NULL; }
	;

/* existence test: returns a BSQL_BOOL node */
existence_test:
		EXISTS subquery		{
			/* generate a SELECT COUNT(*) for subquery */
			/* generate a > 0  BSQL_CMP */
			$$ = NULL;
		}
	;

/* subquery: returns a BSQL_SUBSEL node */
subquery:
		'(' SELECT opt_all_distinct selection table_exp ')' {	
			$$ = bsql_new_subsel( $4, $5 );
		}
	;

/* missing rules ;( */
table:
	/* empty */	{ ; }
	;

search_cond:
	/* empty */	{ ; }
	;

literal:
	/* empty */	{ ; }
	;
	
opt_column_commalist:
	/* empty */	{ ; }
	;
	
column:
	/* empty */	{ ; }
	;
