%{
/* #include <db/bsql.h> */
#include <bsql_parser.h>
#include <string.h>

int lineno = 1;
void yyerror(char *s);
/* TODO: Rulse for !=, hex, octal, and binary numbers */
%}

%%
[aA][lL][lL]					{ return ALL; }
[aA][nN][dD]					{ return AND; }
[aA][vV][gG]					{ return AVG; }
[mM][iI][nN]					{ return MIN; }
[mM][aA][xX]					{ return MAX; }
[sS][uU][mM]					{ return SUM; }
[cC][oO][uU][nN][tT]				{ return COUNT; }
[aA][nN[yY]						{ return ANY; }
[aA][sS]						{ return AS; }
[bB][eE][tT][wW][eE][eE][nN]			{ return BETWEEN; }
[bB][yY]						{ return BY; }
[cC][lL][oO][sS][eE]				{ return CLOSE; }
[cC][oO][nN][tT][iI][nN][uU][eE]		{ return CONTINUE; }
[cC][uU][rR][rR][eE][nN][tT]			{ return CURRENT; }
[cC][uU][rR][sS][oO][rR]			{ return CURSOR; }
[dD][eE][cC][iI][mM][aA][lL]			{ return DECIMAL; }
[dD][eE][cC][lL][aA][rR][eE]			{ return DECLARE; }
[dD][eE][lL][eE][tT][eE]			{ return DELETE; }
[dD][eE][sS][cC]					{ return DESC; }
[dD][iI][sS][iI][nN][cC][tT]			{ return DISTINCT; }
[eE][sS][cC][aA][pP][eE]			{ return ESCAPE; }
[eE][xX][iI][sS][tT][sS]			{ return EXISTS; }
[fF][eE][tT][cC][hH]				{ return FETCH; }
[fF][oO][rR]					{ return FOR; }
[fF][oO][uU][nN][dD]				{ return FOUND; }
[fF][rR][oO][mM]					{ return FROM; }
[hH][aA][vV][iI][nN][gG]			{ return HAVING; }
[iI][nN]						{ return IN; }
[iI][nN][sS][eE][rR][tT]			{ return INSERT; }
[iI][nN][tT][oO]					{ return INTO; }
[iI][sS]						{ return IS; }
[lL][iI][kK][eE]					{ return LIKE; }
[nN][oO][tT]					{ return NOT; }
[nN][uU][lL][lL]					{ return NULLX; }
[nN][uU][mM][eE][rR][iI][cC]			{ return NUMERIC; }
[oO][fF]						{ return OF; }
[oO][nN]						{ return ON; }
[oO][pP][eE][nN]					{ return OPEN; }
[oO][rR]						{ return OR; }
[oO][rR][dD][eE][rR]				{ return ORDER; }
[rR][eE][fF][eE][rR][eE][nN][cC][eE][sS]	{ return REFERENCES; }
[sS][eE][lL][eE][cC][tT]			{ return SELECT; }
[sS][eE][tT]					{ return SET; }
[sS][oO][mM][eE]					{ return SOME; }
[tT][aA][bB][lL][eE]				{ return TABLE; }
[tT][oO]						{ return TO; }
[uU][nN][iI][oO][nN]				{ return UNION; }
[uU][nN][iI][qQ][uU][eE]			{ return UNIQUE; }
[uU][pP][dD][aA][tT][eE]			{ return UPDATE; }
[vV][aA][lL][uU][eE][sS]			{ return VALUES; }
[vV][iI][eE][wW]					{ return VIEW; }
[wW][hH][eE][rR][eE]				{ return WHERE; }
[wW][iI][tT][hH]					{ return WITH; }
[wW][oO][rR][kK]					{ return WORK; }

"=" 	| 
"<>" 	| 
"<" 	| 
">" 	| 
"<=" 	| 
">="						{ return COMPARISON; }

[-+*/:(),.;]				{ return yytext[0]; }
[A-Za-z][A-Za-z0-9_]*			{ return NAME; }
[0-9]+		|
[0-9]+"."[0-9]+ 	|
"."[0-9]+					{ return INTNUM; }

[0-9]+[eE][+-]?[0-9]+ |
[0-9]+"."[0-9]+[eE][+-]?[0-9]+ |
"."[0-9]+[eE][+-]?[0-9]+		{ return APPROXNUM; }

0[xX][0-9A-Fa-f]+				{ return HEXNUM; }
0[bB][01]+					{ return BINNUM; }
'[^'\n]*'					{ 	int c = input();
							unput(c);
							if ( c != '\"' ) return STRING;
							else yymore(); 
						}
'[^'\n]*$					{ yyerror("Unterminated string"); }
\n						lineno++;
[ \t\r]					;
"--".*					;	/* SQL comment */
.						yyerror("invalid character");
%%

void yyerror( char *s ) {
	printf( "%d: %s at %s\n", lineno, s, yytext );
}

main( int argc, char **argv ) {
	/* deal with yyin */
	if (! yyparse() ) {
		/* deal with err */
	}
}
