struct MZ_HEADER {
	char id[2];				/* 'MZ' or 'ZM' */
	unsigned short last_pg_size;	/* number of bytes in last 512-byte page */
	unsigned short num_pages;	/* number of 512-byte pages */
	unsigned short num_reloc;	/* number of relocation entries */
	unsigned short hdr_size;	/* size of header in 16-byte paragraphs */
	unsigned short min_alloc;	/* minimum # of paragraphs alloc'ed */
	unsigned short max_alloc;	/* maximum # of paragraphs alloc'ed */
	unsigned short start_ss;	/* initial SS */
	unsigned short start_sp;	/* initial SP */
	unsigned short checksum;
	unsigned long cs_ip;		/* offset of initial CS:IP: entry point */
	unsigned short reloc_table;	/* offset of relocation table */
	unsigned short overlay;	/* overlay number */
 };

struct MZ_RELOC {
	unsigned short offset;	/* offset of relocation within segment */
	 unsigned short segment;	/* segment of relocation */
};

/* Start of Load Module within file: */ 
/* 	MZ_IMAGE_ADDR( struct MZ_HEADER *h )  */ 
#define MZ_IMAGE_ADDR(x) ( x->hdr_size * 16 )
    
/* Size of Load Module: */ 
/*	MZ_IMAGE_SIZE( struct MZ_HEADER *h )  */ 
#define MZ_IMAGE_SIZE(x) ( x->num_pages * 512 - MZ_IMAGE_ADDR(x) - \
    (512 - x->last_pg_size)) 

/* Size of Relocation table: */
/*    MZ_RELOC_SIZE( struct MZ_HEADER *h )  */
#define MZ_RELOC_SIZE(x) ( x->num_reloc * sizeof(struct MZ_RELOC) )

/* Offset in file of a relocation entry: */ 
/* 	MZ_RELOC_OFFSET( struct MZ_HEADER *h, struct MZ_RELOC *r ) */ 
#define MZ_RELOC_OFFSET(x, y) ( y->segment * 16 + y->offset + MZ_IMAGE_ADDR(x) )

/* Size of .text segment: */
/* 	MZ_TEXT_SIZE( struct MZ_HEADER *h ) */
#define MZ_TEXT_SIZE(x) ( MZ_IMAGE_SIZE(x) - MZ_RELOC_SIZE(x) )

/* Offset in file of .text segment: */
/* 	MZ_TEXT_ADDR( struct MZ_HEADER *h ) */
#define MZ_TEXT_ADDR(x) ( MZ_IMAGE_ADDR(x) + MZ_RELOC_SIZE(x) )
	
/* Load address of .text segment: */
/* 	MZ_TEXT_RVA( struct MZ_HEADER *h ) */
#define MZ_TEXT_RVA(x) ( x.cs_ip - MZ_TEXT_ADDR(x) )
    
/* Startup state of the MZ executable:
	AX		# of chars in command tail, or 0
	BX:CX 	Load Module memory size [32-bit]
	DX		0
	SS:SP		h->SS:h->SP or CS:FFFF
	DS		segment address of MZ header
	ES		same
	CS:IP		program entry point
*/ 
    
/* expansions from ralph brown: offsets are from start of file: */ 
struct MZ_NE {		/* new executable */
	char pad[4];		/* ???? */
	unsigned short behavior;	/* "behaviour bits */
	char reserved[26];
	unsigned long ne_header;	/* offset of NE header */
};

struct MZ_TLINK {
	char sig[2];		/* 0x0100 */
	char id;		/* 0xFB */
	char ver;		/* TLink version, hi nibble = major */
	char pad[2];
};

#define IS_MZ_TLINK( x ) x->u.tlink.id == 0xFB && x->u.tlink.sig[0] == 0x01

struct MZ_ARJ {		/* ARJ compressed */
	char id[4];		/* 'RJSX' */
};

#define IS_MZ_ARJ( x ) ! strncmp( x->u.arj.id, "RJSX", 4 )

struct MZ_LZ {		/* LZEXE compressed */
	char id[2];		/* 'LZ' */
	char ver[2];		/* '09' == .90, '91' == .91 */
};

#define IS_MZ_LZ( x ) ! strncmp( x->u.lz.id, "LZ", 2 )

struct MZ_PK {		/* PKLITE compressed */
	char ver_lo;
	char ver_hi;		/* Bits 0-3 major, 4 extra comp, 5 multi seg */
	char id[6];		/* 'PKLITE' */
};

#define IS_MZ_PK( x ) ! strncmp( x->u.pk.id, "PKLITE", 6 )

struct MZ_LHARC {		/* LHarc compressed */
	char pad[4];
	char jmp[3];		/* jump to start of extraction code */
	char unk[2];
	char id[12];		/* 'LHarc's SFX ' */
};

#define IS_MZ_LHARC( x ) ! strncmp( x->u.lharc.id, "LHarc's SFX", 11 )

struct MZ_LHA {			/* LHA compressed */
	char pad[8];
	char id[10];		/* 'LHa's SFX 'or 'LHA's SFX ' */
};

#define IS_MZ_LHA( x ) ! strncmp( x->u.lha.id, "LHa's SFX", 9 ) || \
    !strncmp(x->u.lha.id, "LHA's SFX", 9)  

struct MZ_LH {	/* LHA compressed */
	char pad[8];
	char id[8];		/* 'LH's SFX' */
};

#define IS_MZ_LH( x ) ! strncmp( x->u.lh.id, "LH's SFX", 8 )

struct MZ_PKARC {			/* PKARC compressed */
	unsigned long sig;	/* 0x00020001 */
	unsigned short id;	/* 0x0700 */
};

#define IS_MZ_PKARC( x ) x->u.pkarc.sig == 0x20001 && x->u.pkarc.id == 0x700

struct MZ_LARC {			/* LARC compressed */
	char pad[4];
	char id[11];		/*'SFX by LARC ' */
};

#define IS_MZ_LARC( x )  ! strncmp( x->u.larc.id, "SFX by LARC", 11 )

struct MZ_BSA {		/* BSA compressed */
	char id[3];		/* 0x0F 0x00 0xA7 */
};

#define IS_MZ_BSA( x ) x->u.bsa.id[0] == 0x0F && x->u.bsa.id[1] == 0x00 && \
    x->u.bsa.id[2] == 0xA7  

struct MZ_EXPANSION {
	union {
		struct MZ_NE ne;
		struct MZ_TLINK tlink;
		struct MZ_ARJ arj;
		struct MZ_LZ lz;
		struct MZ_PK pk;
		struct MZ_LHARC lharc;
		struct MZ_LHA lha;
		struct MZ_LH lh;
		struct MZ_PKARC pkarc;
		struct MZ_LARC larc;
		struct MZ_BSA bsa;
	} u;
};

/* NE header : no wonder Win16 sucked so bad! */
struct NE_HEADER {
	char	id[2];
	char	linker_maj;		/* linker major version */
	char	linker_min;		/* linker minor version */
	short	entry_tbl_off;	/* entry table offset */
	short	entry_tbl_len;	/* entry table length */
	long	file_load_crc;
	char	prog_flags;
	char	app_flags;
	char	data_seg_idx;
	char	pad;
	short	local_heap_size;
	short	stack_size;
	long	entry;		/* CS:IP */
	long	stack_ptr;		/* SS:SP */
	short	seg_count;		/* # segments */
	short	mod_ref_count;	/* module reference count */
	short	nonres_size;	/* size of nonresident name table */
	short	seg_tbl_off;	/* segment table offset */
	short	res_tbl_off;	/* resource table offset */
	short name_tbl_off;	/* resident names table offset */
	short mod_ref_off;	/* module reference table offset */
	short	imp_name_off;	/* imported names table offset */
	long	nonres_off;		/* nonresident name table offset */
	short entry_count;	/* count of moveable entry point ?? */
	short align_count;	/* alignment size shift count ? */
	short	res_count;		/* # resource table entries */
	char	os;			/* target OS */
	char	os2_flags;		/* man, what is all this crap??? */
	short	return_thunk;	/* offset return thunks/gangbang area */
	short segref_thunk;	/* offset to seg ref thunks/gangbang length */
	short	min_swap;		/* minimum code swap area size */
	short	win_ver;		/* windows version */
};
