#include <bastard.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <extension.h>
#include "magic.h"


/* --------------------------------------------------------------- globals */

int nmagic = 0;	/* number of valid magic[]s 		*/
struct  magic *magic;	/* array of magic entries		*/
extern struct EXT__FORMAT  *ext_format;

/*  -------------------------------------------------------------------main()
*/
int read_header(void)
{
	struct DISASM_TGT *target;
	char *tmp_hdr, magicfile[PATH_MAX];
	char	buf[HOWMANY+1];	/* one extra for terminating '\0' */
	int nbytes = 0;	/* number of bytes read from a datafile */
	char match = '\0';
	char msg[64];
	struct MAGIC_FORMAT format = {0};
	struct EXTENSION *ext = &ext_format->ext;

	target = env_get_target();

	/* prepare magicfile */
	snprintf( magicfile, PATH_MAX, "%s/formats/%s", env_get_share(), 
			MAGIC_FILE);
	if ( apprentice(magicfile, 0) > 0 ) {
		sys_errmsg(4594, "Unable to parse MAGIC.types");
		return(2);
	}
	lseek(target->fd, 0, SEEK_SET);
	nbytes = read(target->fd, buf, HOWMANY);

	if (nbytes > 0) {
		buf[nbytes++] = '\0';	/* null-terminate it */
		if (softmagic(buf, nbytes, &format)) {
			sprintf( msg, "MAGIC: Found format %s\n", format.name );
			sys_msg( msg );
			free(ext->filename);
			memset(ext, 0, sizeof (struct EXTENSION));

			if ( ! target_set_format( format.name, format.options ) ||
			     ! target_apply_format()  ) {
				sys_errmsg(4594, "Unable to load file format");
				return(-1); 
			}
			return(0);
		} 
	}

	sys_errmsg(4594, "Unable to identify file format");

	return (-1);
}
