#include <stdlib.h>
#include <string.h>
#include <bastard.h>
#include <extension.h>


struct EXT__COMP *settings;

void ext_comp_init(void *param)
{
	settings = (struct EXT__COMP *) param;

	/* set Compiler-Specific information */
	if (!param)
		return;

	return;
}

struct COMP_FPARAM_LIST {
	struct func_param p;
	int init;
	struct COMP_FPARAM_LIST *next;
};

int comp_funcargs_add( struct COMP_FPARAM_LIST *vars, int op, int type, int i){
	struct COMP_FPARAM_LIST *v;
	int t = type & OP_TYPE_MASK;

	for ( v = vars->next; v; v = v->next ) {
		if ( v->p.addr_exp == op && v->p.flags == t ) 
			return(0);
	}
	v = vars->next;
	vars->next = calloc( sizeof(struct COMP_FPARAM_LIST), 1 );
	vars->next->next = v;
	vars->next->p.addr_exp = op;
	vars->next->p.flags = t;
	vars->next->init = i;
	return(1);
}

void comp_funcargs_cb(void *item, void *data) {
	struct code *c = item;

	if ( c->srcType && (c->destType & OP_W) ) {
		comp_funcargs_add( data, c->dest, c->destType, 1 );
	}

	if (! c->srcType && (c->destType & OP_R) && ! (c->destType & OP_IMM) ) {
		comp_funcargs_add( data, c->dest, c->destType, 0 );
	} else if ( (c->srcType & OP_R) && ! (c->srcType & OP_IMM) )  {
		comp_funcargs_add( data, c->src, c->srcType, 0 );
	}
	return;
}

int comp_funcargs_sortadd( struct COMP_FPARAM_LIST *list, 
					struct COMP_FPARAM_LIST *new ){
	struct COMP_FPARAM_LIST *prev, *curr;

	for ( prev=list, curr = list->next; curr; prev=curr, curr = curr->next) {
		if ( curr->p.flags == OP_REG && 
			new->p.flags == OP_REG &&
			new->p.addr_exp < curr->p.addr_exp )
			break;	/* insert here */
		if ( curr->p.flags == OP_EXPR &&
			new->p.flags == OP_EXPR &&
			new->p.id < curr->p.id )	/* reverse order of push */
			break;	/* insert here */
		/* else insert somewhere after the current one */
	}
	new->next = prev->next;
	prev->next = new;
	return(1);
}

/* generate arguments for function */
int comp_func_genargs( struct function *f ) {
	struct addr_exp a;
	int *state;
	struct COMP_FPARAM_LIST *v, vars={0}, args={0};

	state = db_save_state();
	/* foreach OP_R, if ! init, make local var */
	func_foreach_code( f, comp_funcargs_cb, &vars);

	/* strip things that aren't args */
	for ( v = vars.next; v; v = vars.next ) {
		vars.next = v->next;
		if ( ! v->init ) {
			/* we have a possible argument */
			if ( v->p.flags == OP_REG && v->p.addr_exp < ext_arch->SP ){
				/* this is a register parameter */
				comp_funcargs_sortadd(&args, v);
			} else if ( v->p.flags == OP_EXPR ) {
				if( bdb_index_find( ADDR_EXP_ID, &v->p.addr_exp, &a) &&
					  a.base == ext_arch->FP && a.disp < 0 ) {
				/* this is a stack parameter */
					v->p.id = a.disp * -1;	/* temp order */
					comp_funcargs_sortadd(&args, v);
				}
			/* note that we could add a case for input list pointers
			     here, if the language supported them */
			} else {
				free(v);
			}
		} 
	}

	/* woohoo! monolithism rocks! */

	/* add and free the list of args*/
	for ( v = args.next; v; v = args.next ) {
		args.next = v->next;
		v->p.size = 1;
		v->p.func = f->id;
		bdb_record_insert( FUNC_PARAM, &v->p );
		free(v);
	}

	db_restore_state(state);

	return(1);
}

struct COMP_EFFECT_LIST {
	struct code_effect e;
	struct COMP_EFFECT_LIST *next;
};

int comp_effect_upd( struct code_effect *dest, struct code_effect *src ) {
	switch ( src->change ) {
		case CEFFECT_DIV: case CEFFECT_MUL:
			if ( dest->change == src->change ) {
				dest->amount *= src->amount;
				return(1);
			}
			break;
		case CEFFECT_ADD: case CEFFECT_SUB:
			if ( dest->change == src->change ) {
				dest->amount += src->amount;
				return(1);
			}
			break;
	}

	dest->change = src->change;
	dest->amount = 0;
	return(1);
}

/* call back to manage function vars */
void comp_funceffect_cb(void *item, void *data) {
	int cont, *state;
	struct COMP_EFFECT_LIST new, *list = data;
	struct code *c = item;

	state = db_save_state();
	cont = bdb_index_find( CODE_EFFECT_RVAID, &c->rva, &new.e ); 
	while ( cont && new.e.rva == c->rva ) {
		list = data;
		new.next = list->next;
		list->next = calloc( sizeof(struct COMP_EFFECT_LIST), 1 );
		memcpy( list->next, &new, sizeof(struct COMP_EFFECT_LIST) );
		cont = bdb_index_next( CODE_EFFECT_RVAID, &new.e );
	}
	db_restore_state(state);

	return;
}

/* determine side effects of function */
int comp_func_effect( struct function *f ) {
	int *state;
	struct COMP_EFFECT_LIST *l, effect_list = {0};

	state = db_save_state();
	func_foreach_code( f, comp_funceffect_cb, &effect_list);

	for ( l = effect_list.next; l; l = effect_list.next ) {
		effect_list.next = l->next;
/* TODO: shit. need to manage stack in here for save/restore */
		//printf("function effect: loc %x(%x) change %x(%x)\n",
		//		l->e.loc, l->e.type, l->e.change, l->e.amount);
		bdb_record_insert( FUNC_EFFECT, &l->e );
		free(l);
	}
	db_restore_state(state);
	
	return(1);
}

int add_data_types(int mach_word)
{
	/* TODO: someday make this param actually be used */
	switch (mach_word) {
	case 2:
	case 4:
	case 8:
	default:
		settings->s4 = dtype_new("int", 4, DT_SIGNED);
		settings->u4 = dtype_new("unsigned int", 4, DT_UNSIGNED);
		settings->s2 = dtype_new("short", 2, DT_SIGNED);
		settings->u2 = dtype_new("unsigned short", 2, DT_UNSIGNED);
		settings->s1 = dtype_new("char", 1, DT_SIGNED);
		settings->u1 = dtype_new("unsigned char", 1, DT_UNSIGNED);
		dtype_new("long", 4, DT_SIGNED);
		dtype_new("unsigned long", 4, DT_UNSIGNED);
		settings->s8 = dtype_new("long long", 8, DT_SIGNED);
		settings->u8 = dtype_new("unsigned long long", 8, DT_UNSIGNED);
		dtype_new("float", 4, DT_UNSIGNED);
		dtype_new("double", 8, DT_UNSIGNED);
		dtype_new("long double", 12, DT_UNSIGNED);
	}
	return (1);
}

int makestr(char *buf, char *text, int text_len, int type)
{
	char *ptr = buf;
	int len = 0;

	switch (type) {
	case STR_STD:
		/* get length of string */
		while (*ptr)
			ptr++;
		len = ptr - buf;
		/* make text representation from string */
		strncpy(text, buf, text_len - 1);
		text[text_len] = 0;
		break;
	case STR_WIDE:
		break;
	}
	return (len);		/* return length of string */
}

/* buf     : buffer to search for string
 * len     : length of buffer
 * pos     : pointer to integer to fill w/ offset into buffer of found string
 * text    : buffer to copy found string to
 * text_len: size of buffer 'text'
 * type    : type of string [wide or standard]
 * returns : size of string found */
#define isgood(x) ( (x >= 0x20 && x <= 0x7E) || (x >= 0x09 && x <= 0x0D) )
int findstr(char *buf, int len, int *pos, char *text, int text_len, int type)
{
	int x, size;
	unsigned char *c;

	for (x = 0; x < len; ++x) {
		/* look for a minimum string length of 4 chars */

		c = &buf[x];
		switch (type) {
		case STR_STD:
			if (isgood(c[0]) && isgood(c[1]) && isgood(c[2]) &&
			    isgood(c[3])) {
				/* we have a suspect */
				size = 4;
				while (isgood(c[size]))
					++size;
				if (!buf[x + size]) {	/* check for buffer termination */
					/* we have a string! */
					strncpy(text, &buf[x], text_len);
					*pos = x;
					return (size);
				}
			}
			break;
		case STR_WIDE:
			break;
		}		/* end switch */

	}
	return (0);
}
