#include <cli/bastard_main.h>


static struct ACTION cmd_table[] = {
	{"HELP", '?', 0, &cmd_help,
	 "                        \t: This help screen."},
	{"API", 0, 0, &cmdAPI,
	 "                         \t: Display bastard.h"},
	{"BDB", 'B', 0, &cmdBDB,
	 "[filename]               \t: Load a .bdb file"},
	{"COMMENT", 'C', 0, &cmdCOMMENT,
	 " name [comment]          \t: Set or display comment for address/name 'name'"},
	{"DB", 0, 1, &cmdDB,
	 "[command]                 \t: sys_execute a database command. Try \'DB ?\'"},
	{"DEBUG", 0, 0, &cmdDEBUG,
	 "                       \t: Run target  in an external debugger"},
	{"DISASM", 'D', 0, &cmdDISASM,
	 "[filename]            \t: Display a disassembly of the target; use \'filename\' or STDOUT"},
	{"DUMP", 'U', 0, &cmdDUMP,
	 "                        \t: Print hexdump of target"},
	{"ENTRY", 'E', 0, &cmdENTRY,
	 "                        \t: Display a disassembly of the entry point"},
	{"EXEC", '!', 0, &cmdEXEC,
	 "[command]               \t: sys_execute command in a shell"},
	{"EXT", 'X', 0, &cmdEXT,
	 "[ext] [name]            \t: Set extension 'ext' to 'name'"},
	{"FIND", 'F', 2, &cmdFIND,
	 "[command]                 \t: Search disassembly. Try \'FIND ?\'"},
	{"HEADER", 'H', 0, &cmdHEADER,
	 "                      \t: Display target file header"},
	{"HOWTO", 0, 0, &cmdHOWTO,
	 "                       \t: Display the Disasm-HOWTO"},
	{"INTCODE", 'I', 0, &cmdINT,
	 "[filename]            \t: Display intermediate code version of the target; use \'filename\' or STDOUT"},
	{"LOAD", 'L', 0, &cmdLOAD,
	 " [target] [format] [cpu]\t: Load/disassemble target. Parameters override compiled defaults"},
	//{ "MACRO", 0, 0, &cmdMACRO, "[name]                 \t: Start writing a command-line macro/batch file" },
	{"MAN", 'M', 0, &cmdMAN,
	 "                         \t: Display bastard manual"},
	{"NAME", 'N', 0, &cmdNAME,
	 " [name] [new_name]       \t: Display disassembly of or rename named location"},
	//{ "ENDMACRO", 0, 0, &cmdENDMACRO, "\t: Stop writing a command-line macro/batch file" },
	{"OUTPUT", 'O', 0, &cmdOUTPUT, 
	" format [filename]      \t: Output in 'format' to 'filename' or STDOUT"},
	{"PLUGIN", 'P', 0, &cmdPLUGIN, 
	" name [function] [arg]  \t: Call 'function' in plugin 'name' with argument 'arg'"},
	{"PRELOAD", 'U', 0, &cmdPRELOAD,
	 "                        \t: Load target but do not apply extensions or disasemble"},
	{"QUIT", 'Q', 0, &cmdQUIT,
	 "                        \t: Exit the disassembler"},
	{"RANGE", 'R', 0, &cmdRANGE,
	 "[start] [end]          \t: Display disassembly of addresses between \'start\' and \'end\'"},
	//{ "RECORD", 0, 0, &cmdRECORD, "[name]\t: Start recording a command-line macro/batch file" },
	//{ "STOP", 0, 0, &cmdSTOP, "\t: Stop recording" },
	{"RUN", 0, 0, &cmdRUN,
	 "[name]                   \t: Run a macro/batch file"},
	{"SECTION", 'S', 0, &cmdSECTION,
	 "[name]               \t: Print section \'name\'"},
	{"SET", 0, 0, &cmdSET,
	 "[variable] [value]       \t: Set bastard flags."},
	{"SHOW", 0, 0, &cmdSHOW,
	 "[variable]              \t: Display settings of bastard flags"},
	/* these two are here to allow aliases; they are also under SIG*/
	{"SIG_GEN", 'G', 0, &cmdSIGGEN,
	 "[filename] [entry]      \t: Generate a signature file for the target"},
	{"SIG_ID", 'Y', 0, &cmdSIGID,
	 "[path]              \t: Compare entry point with signature files to identify compiler stdlib"},
	{"SIG", 0, 3, &cmdSIG,
	 "[command]                 \t: Work with library signatures Try \'SIG ?\'"},
	{"STRINGS", 'A', 0, &cmdSTRINGS,
	 "                     \t: Display strings in target"},
	{"VERSION", 'V', 0, &cmdVERSION,
	 "                     \t: Display version information for bastard and plugins"},
	{"{{", 0, 0, &cmdBRACE,
	 "                          \t: Write and execute a BC script [end script with }}]"},
	{NULL, 0, 0, NULL, NULL}
};

struct SUBACTION static
 db_tbl[] = {			/* 1 */
	{"HELP", &subcmd_help, ":\tDB Help. This help screen."},
	{"COUNT", &db_count_cmd, "[table]\t: Count number of records in table"},
	{"DESC", &db_desc_cmd, "[table]\t: Describe table"},
	{"DUMP", &db_dump_cmd, "[table]\t: Dump contents of table to STDOUT"},
	
	{"MAX", &db_max_cmd, "[table] [key]\t: Find record in table where "
		"key has the greatest value"},
	{"MIN", &db_min_cmd, "[table] [key]\t: Find record in table where "
		"key has the least value"},
	{NULL, NULL, NULL}
},
find_tbl[] = { // 2
	{ "HELP", &subcmd_help, ":\tFIND Help. This help screen."},
      { "INSN", &cmdFINDINSN, "[str]\t: Find instruction by mnemonic" },
      { "OP", &cmdFINDOP, "[num]\t: Find uses of immediate/address value as an operand" },
      { "REG", &cmdFINDREG, "[str]\t: Find uses of register as an operand" },
      { "XREF", &cmdFINDXREF, "[addr]\t: Find references to address" },
      { "NAME", &cmdFINDNAME, "[str]\t: Find references to name" },
      { "BYTES", &cmdFINDBYTES, "[str]\t: Find Hex Bytes [e.g.\"00 01 02\"]" },
      { NULL, NULL, NULL}
},
sig_tbl[] = { // 3
	{ "HELP", &subcmd_help, ":\tSIG Help. This help screen."},
	{"GEN", &cmdSIGGEN, "[filename] [entry]\t: Generate a signature file"},
	{"ID", &cmdSIGID, "[path]\t: Compare entry point with signature files"},
	{"LOAD", &cmdSIGLOAD, "filename\t: Load a signature file"},
	{"MATCH", &cmdSIGMATCH, "[path]\t: Match loaded signatures to target functions"},
      { NULL, NULL, NULL}
},
   /*set_tbl[] = { // 2
      { "HELP", &subcmd_help, "SET Help: This help screen" },
      { NULL, NULL, NULL}
      },
      show_tbl[] = { // 3
    */
*sub_cmd_tbl[] = {
db_tbl, find_tbl, sig_tbl
};			//, set_tbl, show_tbl };;


#define CMDLINE_PIPE	1
#define CMDLINE_REDIR	2

/* ======================================= Actual functions */

int istrcmp(char *s1, char *s2)
{
	int j;

	for (j = 0;; j++) {
		if ((!s1[j] || isspace(s1[j])) && !s2[j])
			break;
		if (toupper(s1[j]) != s2[j])
			return (0);
		if (!s1[j] || !s2[j])
			return (0);
	}
	return (j);
}

int ProcessCommand(char *buf)
{
	int i, old_out, pos = 0, start = 0;
	char in_dquote = 0, in_squote = 0;
	struct ACTION *cmd;
	struct SUBACTION *sublist, *subcmd;
	struct COMMAND *cmdline;
	char *ptr, u;
	FILE *pipe;

	if (! buf[0]) 	return(0);
	/* strip leading whitespace */
	while (isspace(buf[start]))
		++start;
	/* strip trailing space and newline */
	i = strlen(buf) - 1;
	if (isspace(buf[i]))
		buf[i] = 0;

	/* =================== Get Main Command ======================= */
	u = toupper(buf[start]);
	for (i = 0; cmd_table[i].name != NULL; i++) {
		cmd = &cmd_table[i];
		/* check for match against alias */
		if (u == cmd->alias
		    && (!buf[start + 1] || isspace(buf[start + 1]))) {
			pos++;	/* advance past command */
			break;
		}
		/*check for match against name */
		if (pos = istrcmp(&buf[start], cmd->name))
			break;
		cmd = NULL;	//&cmd_table[0]; /* HELP is always 0 */
	}

	if (!cmd)
		return (0);	/* no match */
	/* At this point, command is filled */
	cmdline = (struct COMMAND *) calloc(sizeof (struct COMMAND), 1);
	if (!cmdline)
		return (0);
	strncpy(cmdline->command, cmd->name, 32);
	cmdline->fn = cmd->handler;

	/* ================== Get SubCommand ========================== */
	start = pos;
	while (isspace(buf[start]))
		++start;
	buf = &buf[start];
	start = pos = 0;

	if (buf[start] && cmd->sub_cmd) {
		sublist = sub_cmd_tbl[cmd->sub_cmd - 1];
		for (i = 0; sublist[i].name != NULL; i++) {
			subcmd = &sublist[i];
			if (pos = istrcmp(&buf[start], subcmd->name))
				break;
			subcmd = &sublist[0];	/* HELP is always 0 */
		}
		sublist = NULL;
		strncpy(cmdline->subcmd, subcmd->name, 32);
		cmdline->sub_tbl = cmd->sub_cmd - 1;
		cmdline->fn = subcmd->handler;
	}
	if ( ! cmdline->fn ) {
		free(cmdline);
		return (1);
	}

	/* ================== Check for extension ======================= */
	start = pos;
	if (buf[0] &&
	    (ptr = strchr(&buf[start], '|')) ||
	    (ptr = strchr(&buf[start], '>'))) {

		if (*ptr == '|')
			cmdline->extension = CMDLINE_PIPE;
		else
			cmdline->extension = CMDLINE_REDIR;
		ptr[0] = '\0';	/* end command line here */
		ptr++;
		/* remove newline and leading whitespace */
		while (isspace(ptr[0]))
			ptr++;
		if (ptr[strlen(ptr) - 1] == '\n')
			ptr[strlen(ptr) - 1] = '\0';
		cmdline->cline = malloc(1024);
		if (!cmdline->cline)
			return (0);
		/* text following "|" becomes command line */
		strncpy(cmdline->cline, ptr, 1023);
	}

	/* ========================= Get Args ============================== */
	while (isspace(buf[start]))
		start++;
	buf = &buf[start];
	pos = start = 0;
	if (buf[pos]) {		/* don't even try this if there is no more data */
		cmdline->argc++;
		while (buf[pos]) {
			if ( buf[pos] == '\'' && ( !pos || buf[pos-1] != '\\') ) 
				in_squote = ( in_squote > 0 ) ? 0 : 1;

			if ( buf[pos] == '\"' && ( !pos || buf[pos-1] != '\\') )
				in_dquote = ( in_dquote > 0 ) ? 0 : 1;

			if ( ! in_dquote && ! in_squote && isspace(buf[pos])) {
				while (isspace(buf[pos]))
					pos++;	/* suck up all whitespace */
				if (buf[pos]) {
					pos--;		/* back up one :) */
					cmdline->argc++;	/* ignore space at end of line */
				}
			}
			pos++;
		}
		
		/* check for open quotes */
		if ( in_dquote || in_squote ) {
			fprintf( stderr, "Command Error: Unmatched %c\n",
					((in_dquote) ? '\"' : '\'') );
			return(0);
		}
		in_dquote = in_squote = 0;

		cmdline->argv = calloc(cmdline->argc, sizeof (char *));
		if (!cmdline->argv)
			return (0);

		if (cmdline->argc)
			cmdline->argv[0] = &buf[start];
		i = 1;
		while (cmdline->argc && buf[start] && i < cmdline->argc) {
			if ( buf[start] == '\'' && ( !start || buf[start-1] != '\\') ) 
				in_squote = ( in_squote  ) ? 0 : 1;

			if ( buf[start] == '\"' && ( !start || buf[start-1] != '\\') )
				in_dquote = ( in_dquote ) ? 0 : 1;

			if ( ! in_dquote && ! in_squote && isspace(buf[start])) {
				buf[start] = '\0';
				while (isspace(buf[++start]))
					;
				if (buf[start]) {
					cmdline->argv[i] = &buf[start];
					i++;	/* increment arg count */
				}
			} else {
				start++;
			}
		}
	}

	/* end arg processing */
	/* ================== Call fn to Handle Command ==================== */
	if (!cmdline->extension && (env_get_opt_flag(PAGINATE))) {
		cmdline->extension = CMDLINE_PIPE;
		cmdline->cline = env_get_pager();
	}
	if (cmdline->extension == CMDLINE_PIPE) {
		pipe = popen(cmdline->cline, "w");
		old_out = dup(STDOUT_FILENO);
		dup2( fileno(pipe), STDOUT_FILENO );
	} else if (cmdline->extension == CMDLINE_REDIR) {
		pipe = fopen(cmdline->cline, "a");
		old_out = dup(STDOUT_FILENO);
		dup2( fileno(pipe), STDOUT_FILENO );
	}
	((CmdHandler) * cmdline->fn) (cmdline->argc, cmdline->argv, cmdline);
	if (cmdline->extension == CMDLINE_PIPE) {
		dup2( old_out, STDOUT_FILENO );
		fflush(pipe);
		pclose(pipe);
		close( old_out );
	} else if (cmdline->extension == CMDLINE_REDIR) {
		dup2( old_out, STDOUT_FILENO );
		fflush(pipe);
		fclose(pipe);
	}

	if (cmdline->argv)
		free(cmdline->argv);
	if (cmdline->cline)
		free(cmdline->cline);
	free(cmdline);
	return (1);
}

void *cmd_help(int argc, char **argv, struct COMMAND *c)
{
	int x;

	printf("Help Topic: MAIN\n");
	for (x = 0; cmd_table[x].name != NULL; x++) {
		printf("   %s %s", cmd_table[x].name, cmd_table[x].helpstr);
		if (cmd_table[x].alias)
			printf(" (Alias: %c)", cmd_table[x].alias);
		printf("\n");
	}
	return;
}
void *subcmd_help(int argc, char **argv, struct COMMAND *c)
{
	/*print ->name, ->alias, ->helpstr */
	struct SUBACTION *sublist;
	int x;

	printf("Help Topic: %s\n", c->command);
	sublist = sub_cmd_tbl[c->sub_tbl];
	for (x = 0; sublist[x].name != NULL; x++) {
		printf("   %s %s\n", sublist[x].name, sublist[x].helpstr);
	}
	return;
}
