/* bastard.c : part of The Bastard disassembly environment ====================
 *
 * Contains initialization code, signal handlers, and the command line
 * interpreter [using the readline library]
 */


#include <cli/bastard_main.h>
#include <readline/readline.h>
#include <readline/history.h>

//#include <config.h>

char *cmd;
int caught_sig_kill = 0;
int binfromstdin = 0, runbatch = 0;
FILE *batch_file;
/* note: runbatch is extern'ed for CMD_BRACE, QUIT in cli_cmd.c */

int command_loop( struct DISASM_ENV *e, struct DISASM_PREFS *p) {
   while (! env_get_flag(QUIT_NOW) ) {
      if (! (p->options & QUIET)) cmd = readline(e->p1);
      else cmd = readline("");
	if (cmd) {
      		add_history(cmd);
      		if (! ProcessCommand(cmd) )
            		script_text_exec(cmd);
      		free(cmd);
	}
   }
   return(0);
}
//______________________________________________________________user_kill()
void user_kill( int sig) {
   if ( cmd != NULL) {
	free(cmd);
	cmd = NULL;
   }
   if (! caught_sig_kill ) {
      caught_sig_kill = 1;
      if ( env_get_flag(IN_EIC) ) {
	   /* if this happened in EiC, we can recover */
         sys_init_interpreter(); /* restart EiC */
         caught_sig_kill = 0;
         env_set_flag(IN_EIC);
         command_loop(env_get_env(), env_get_prefs());
      } else { 
         printf("GodDAMNIT! I can't do ANYTHING!\n");
         cmdQUIT(0, NULL, NULL);
         /* execution should never reach here */
         printf("bastard! killed by signal %d\n", sig);
         if ( env_get_flag(QUIET))  pclose(  popen("stty echo", "r") );
         env_set_flag( QUIT_NOW );
         exit(sig);
      }
   }
}
//______________________________________________________________ReadPrefs()
void ReadPrefs( char* filename ){
   /* to be written :P */
   FILE *f;
   char group[64] = {0}, name[256], buf[256];
   f = fopen(filename, "r");
   /* allow comments  and GROUP.NAME=VALUE lines */
   while ( fscanf(f, "%[# ]%[^\n]\n", name, buf) > 0 ||
         fscanf(f, "%[^.].%[^ =] = %s\n", group, name, buf) > 0){
      if (  group[0] &&
          ! env_set_setting(group, name, buf) &&
          ! env_set_option(name) ){
         printf("Invalid Option %s.%s = %s\n", group, name, buf);
      }
      group[0] = '\0';
   }
   fclose(f);
   return;
}

void GetCommandHistory(){
   FILE *f;
   char *c, buf[256];

   sprintf(buf, "%s/.bastard/cmd_history", getenv("HOME"));
   if ( f = fopen(buf, "r") ) {
      while (fgets(buf, 256, f)){
         if ( c = strrchr(buf, '\n')) *c = '\0';
         add_history(buf);
      }
   }
}

int run_batch( char *script ){
	FILE *f = NULL;
	struct stat s;
	char buf[PATH_MAX];
	struct DISASM_ENV *e;

	e = env_get_env();
	if ( stat( script, &s ) ){
		/* 'script' doesn't exist, try default loc */
		sprintf( buf, "%s/scripts/macros/%s", e->share, script );
		if ( ! stat(  buf, &s ) )
			f= fopen( buf, "r" );
	} else {
		f = fopen( script, "r" );
	}
	if (! f) {
		fprintf(stderr, "Error: %s not found even in %s/scripts/macros\n",
				script, e->share );
		return(0);
	}
	batch_file = f;

	env_set_option( "DONT_SAVE" );
	env_set_option( "QUIET" );

	while( fgets( buf, PATH_MAX, f ) ) {
		//if ( strncmp( cmd, "#!", 2 ) ) {
		if ( buf[0] == '#' && buf[1] == '!' ) {
			/* skip shebangs from scripts */
		} else {
      		if (! ProcessCommand(buf) )
            		script_text_exec(buf);
		}
	}
	return(1);
}
//___________________________________________________________________main()
int main (int argc, char* argv[]){
   int x, fd, retVal = 0;
   FILE *fTemp, *oldIN, *oldOUT, *oldERR, *newSTR;
   char buf[PATH_MAX], *tmp, *script=NULL;
   struct stat tmpStat;
   struct DISASM_ENV *disasm_env;
   struct DISASM_PREFS *disasm_prefs;
   struct DISASM_TGT *target;

   /* prepare bastard-settings structure pointers */
   disasm_env = env_get_env();
   disasm_prefs = env_get_prefs();
   target = env_get_target();
   caught_sig_kill = 0;


   /* ----------------- Setup Operations Environment -------------- */
   /* set defaults, start DB && interpreter */
   if (! sys_find_base(buf, PATH_MAX, argv) ||
	 ! sys_init(buf) ) {
      sys_print_errmsg( sys_get_lasterr() );
	return(-1);
   }

   oldIN = stdin; oldOUT = stdout; oldERR = stderr;

   /* + Apply settings in RC scripts */
   if ( ! stat("/etc/bastard.rc", &tmpStat)) ReadPrefs("/etc/bastard.rc");
   sprintf(buf, "%s/.bastard/bastard.rc", getenv("HOME"));
   if ( ! stat(buf, &tmpStat)) ReadPrefs(buf);

   /* + Trap User Signals */
   signal( SIGKILL, user_kill);
   signal( SIGABRT, user_kill);
   signal( SIGINT, user_kill);
   signal( SIGTERM, user_kill);
   signal( SIGSEGV, user_kill);
   signal( SIGPIPE, SIG_IGN);
   
   /* ------------------- Command Line Options  -------------------- */
   for (x = 1; x < argc; x++) {
      if (argv[x][0] == '-' ) {
         switch (argv[x][1]) {
            case 'i': /* redirect STDIN */
		  newSTR = freopen(argv[x+1], "r", stdin);
                  if(newSTR == NULL) {
                        sys_set_lasterr(1010);
                        sys_print_errmsg( sys_get_lasterr());
                        return(-1);
                  }
                  x++; /* advance argument past parameter */
                  break;
            case 'o': /* redirect STDOUT */
		  newSTR = freopen(argv[x+1], "w", stdout);
                  if(newSTR == NULL) {
                        sys_set_lasterr(1011);
                        sys_print_errmsg( sys_get_lasterr());
                        return(-1);
                  }
                  x++; 
                  break;
            case 'e': /* redirect STDERR */
		  newSTR = freopen(argv[x+1], "r", stderr);
                  if(newSTR == NULL) {
                        sys_set_lasterr(1012);
                        sys_print_errmsg( sys_get_lasterr());
                        return(-1);
                  }
                  x++; 
                  break;
            case 'b': /* run batch of commands on target */
                  script = argv[x+1];
                  x++;
		case 'n': /* non-interactive */
                  runbatch = 1;
                  break;
            case 'p': /* set prompt */
                  strncpy(disasm_env->p1, argv[x+1], 15);
                  x++; 
                  break;
            case 'a': /* annoy user */
                  disasm_prefs->override |= ANNOY_USER;
                  break;
            case 'q': /* suppress useless output */
                  disasm_prefs->override |= QUIET;
                  pclose(  popen("stty -echo", "r") );
                  break;
            case 'd': /* debug mode */
                  disasm_prefs->override |= DEBUG_TIME;
                  break;
            case 'c': /* colorize output */
                  disasm_prefs->override |= COLOR_TTY;
                  break;
            case '-': /* read file from stdin */
                  binfromstdin = 1;
			runbatch = 1;
                  break;
            case 'v':
                  printf("B A S T A R D   v. %.2f\n", BASTARD_VERSION);
                  return(-1);
                  break;
            case 'h': case '?': default:
                  printf("Usage: %s %s [-i in] [-o out] [-e err]"
                              " [-p p1] [-b batchfile] [filename]\n",
                              argv[0], "[-aqdcnh?]");
                  return(-1);
         }
      /* All non-hyphenated parameters are assumed to be the target */
      } else {
		target_path_info( argv[x] );
      }      
   }
   /* save command-line option overrides in global var */
   disasm_prefs->options |= disasm_prefs->override;


   if ( runbatch ) {
	tmp = NULL;
	/* make tempfile */
   	if ( binfromstdin ) {
		int fd, num;
		char buf[256];

		tmp = calloc( PATH_MAX, 1 );
		sprintf( tmp, "%s/imageXXXXXX", disasm_env->dbpath );
		fd = mkstemp( tmp );
		target_path_info( tmp );
		if (fd == -1)	return(0);
		do {
			num = read( STDIN_FILENO, buf, 256 );
			if ( num )
				write( fd, buf, num );
		} while ( num );
		close(fd);
   	}
	if ( script ) {
		run_batch( script );
	} else { 
		run_batch( "generic_disasm.cmd");
	}
	/* remove temp file */
   	if ( tmp != NULL ) {
		unlink(tmp);
		free(tmp);
	}
	return(0);
   }

   /* ------------------------ Get Started  ------------------------- */
	//if ( !(disasm_prefs->options & QUIET) ) {
   sys_visual("==========================================================="
             "=====================\n");
   sys_visual("   B A S T A R D                    disassembly environment\n");
   sys_visual("   brought to you by the proud folks at the HCU linux forum\n");
   //}

   GetCommandHistory();
   command_loop( disasm_env, disasm_prefs );   

   /* ------------------------ Final Cleanup ----------------------- */
      //if ( stdin != oldIN)   { fclose(stdin); stdin = oldIN; }
      //if ( stdout != oldOUT) { fclose(stdout); stdout = oldOUT; }
      //if ( stderr != oldERR) { fclose(stderr); stderr = oldERR; }

   if ( cmd != NULL) free(cmd);
   if ( ! (disasm_prefs->options & QUIET)) printf("\nYou bastard!\n");
   else pclose(  popen("stty echo", "r") );
   return(0);
}
