#include <stdio.h>
#include <unistd.h>
//#define _GNU_SOURCE
#include <getopt.h>
#include <bastard.h>
#include "bobjdump.h"

extern int optind;

unsigned long display_opts = 0, disasm_opts= 0;
int ext_arch_opts = IGNORE_NULLS;
/* storage for command line argument stuff */
char *user_format = NULL, *user_arch = NULL, *user_asm, *user_sec = NULL;
unsigned long start_addr = 0, stop_addr = 0;
long adj_vma = 0;

int do_strings() {
	/* if BOBJ_DISASM_FULL, dump string section */
	/* else look for strings ourselves */
	return(1);
}
	
int print_section( struct section *s ) {
	struct address a;
	int cont;

	cont = bdb_find_closest_next(ADDRESS_RVA, &s->rva, &a);
	while ( cont && a.rva < s->rva + s->size ) {
		addr_print(a.rva);
		cont = bdb_index_next(ADDRESS_RVA, &a);
	}
	return(1);
}

int print_function( struct function *f ) {
	struct address a;
	int cont;

	cont = bdb_find_closest_next(ADDRESS_RVA, &f->rva, &a);
	while ( cont && a.rva < f->rva + f->size ) {
		addr_print(a.rva);
		cont = bdb_index_next(ADDRESS_RVA, &a);
	}
	return(1);
}

int do_disassembly(){ 
	struct section s;
	struct function f;
	int cont;

	/* make format string */
	if ( display_opts & BOBJ_SHOWADDR ) ;
	if ( display_opts & BOBJ_SHOWBYTE ) ;

	if ( user_sec ) {
		/* disassemble this section */
		if ( bdb_index_find( SECTION_NAME, user_sec, &s ) ) {
			disasm_section( user_sec );
			print_section( &s );
		}
		
	} else if ( disasm_opts == BOBJ_DISASM_X ) {
		cont = bdb_index_first( SECTION_RVA, &s );
		while ( cont ) {
			if ( s.flags & SECTION_EXECUTE ) {
				disasm_section( s.name );
				print_section( &s );
			}
			cont = bdb_index_next( SECTION_RVA, &s );
		}

	} else if ( disasm_opts ==  BOBJ_DISASM_ALL ) {
		cont = bdb_index_first( SECTION_RVA, &s );
		while ( cont ) {
			disasm_section( s.name );
			print_section( &s );
			cont = bdb_index_next( SECTION_RVA, &s );
		}

	}  else {
		/* do 'normal' disassemble */
		disasm_target("full", NULL);

		/* foreach function, print */
		cont = bdb_index_first( FUNCTION_RVA, &f );
		while (cont) {
			print_function( &f );
			cont = bdb_index_next( FUNCTION_RVA, &f );
		}
	}
	return(1);
}

int do_section_display() {
	if ( display_opts & BOBJ_HDR_ARCHIVE ) {
	}
	if ( display_opts & BOBJ_HDR_FILE ) {
	}
	if ( display_opts & BOBJ_HDR_PRIVATE ) {
	}
	if ( display_opts & BOBJ_HDR_SECTION ) {
	}
	if ( display_opts & BOBJ_SEC_FULL ) {
	}
	if ( display_opts & BOBJ_STABS ) {
	}
	if ( display_opts & BOBJ_DEBUG ) {
	}
	if ( display_opts & BOBJ_SYM ) {
	}
	if ( display_opts & BOBJ_DYNSYM ) {
	}
	if ( display_opts & BOBJ_RELOC ) {
	}
	if ( display_opts & BOBJ_DYNRELOC ) {
	}
	return(1);
}
int version() {
	printf( "bobjdump : Bastardized Object File Dump, v. %0.2f\n",
			UTIL_VERSION );
	return(1);
}
int usage() {
  	printf("Usage: bobjdump OPTION... file\n\t");
	version();
  	printf("\tAt least one of the following switches must be given:\n");
  	printf(
"  -A, --ascii-strings      Display ascii strings found in file\n"
"  -a, --archive-headers    Display archive header information\n"
"  -f, --file-headers       Display the contents of the overall file header\n"
"  -h, --[section-]headers  Display the contents of the section headers\n"
"  -x, --all-headers        Display the contents of all headers\n"
"  -d, --disassemble        Display assembler contents of executable sections\n"
"  -D, --disassemble-all    Display assembler contents of all sections\n"
"  -F, --disassemble-full   Display a flow-of-execution disassembly\n"
"  -s, --full-contents      Display the full contents of all sections requested\n"
"  -g, --debugging          Display debug information in object file\n"
"  -G, --stabs              Display (in raw form) any STABS info in the file\n"
"  -t, --syms               Display the contents of the symbol table(s)\n"
"  -T, --dynamic-syms       Display the contents of the dynamic symbol table\n"
"  -r, --reloc              Display the relocation entries in the file\n"
"  -R, --dynamic-reloc      Display the dynamic relocation entries in the file\n"
"  -V, --version            Display this program's version number\n"
"  -i, --info               List object formats and architectures supported\n"
"  -H, --help               Display this information\n"
	"\n" );

      printf(" The following switches are optional:\n");
      printf(
"  -b, --target=FORMAT            Specify the target object format as FORMAT\n"
"  -m, --architecture=ARCH        Specify the target architecture as ARCH\n"
"  -j, --section=NAME             Only display information for section NAME\n"
"  -M, --disassembler-options=OPT Pass text OPT on to the disassembler\n"
"  -EB --endian=big               Assume big endian format when disassembling\n"
"  -EL --endian=little            Assume little endian format when disassembling\n"
"  -z, --disassemble-zeroes       Do not skip blocks of zeroes when disassembling\n"
"      --start-address=ADDR       Only process data whoes address is >= ADDR\n"
"      --stop-address=ADDR        Only process data whoes address is <= ADDR\n"
"      --prefix-addresses         Print complete address alongside disassembly\n"
"      --[no-]show-raw-insn       Display hex alongside symbolic disassembly\n"
"      --intel-syntax		    Display disassembly in Intel syntax\n"
"      --adjust-vma=OFFSET        Add OFFSET to all displayed section addresses\n"
	"\n");
	exit(1);
}



static struct option long_options[]=
{
  {"adjust-vma", required_argument, NULL, OPT_ADJVMA},
  {"all-headers", no_argument, NULL, 'x'},
  {"private-headers", no_argument, NULL, 'p'},
  {"architecture", required_argument, NULL, 'm'},
  {"ascii-strings", no_argument, NULL, 'A'},
  {"archive-headers", no_argument, NULL, 'a'},
  {"debugging", no_argument, NULL, 'g'},
  {"demangle", no_argument, NULL, 'C'},
  {"disassemble", no_argument, NULL, 'd'},
  {"disassemble-all", no_argument, NULL, 'D'},
  {"disassembler-options", required_argument, NULL, 'M'},
  {"disassemble-zeroes", no_argument, NULL, 'z'},
  {"dynamic-reloc", no_argument, NULL, 'R'},
  {"dynamic-syms", no_argument, NULL, 'T'},
  {"endian", required_argument, NULL, OPT_ENDIAN},
  {"file-headers", no_argument, NULL, 'f'},
  {"full-contents", no_argument, NULL, 's'},
  {"headers", no_argument, NULL, 'h'},
  {"help", no_argument, NULL, 'H'},
  {"info", no_argument, NULL, 'i'},
  {"intel-syntax", no_argument, NULL, OPT_INTEL},
  {"line-numbers", no_argument, NULL, 'l'},
  {"no-show-raw-insn", no_argument, NULL, -1},
  {"prefix-addresses", no_argument, NULL, 1},
  {"reloc", no_argument, NULL, 'r'},
  {"section", required_argument, NULL, 'j'},
  {"section-headers", no_argument, NULL, 'h'},
  {"show-raw-insn", no_argument, NULL, 1},
  {"source", no_argument, NULL, 'S'},
  {"stabs", no_argument, NULL, 'G'},
  {"start-address", required_argument, NULL, OPT_STARTADDR },
  {"stop-address", required_argument, NULL, OPT_STOPADDR },
  {"syms", no_argument, NULL, 't'},
  {"target", required_argument, NULL, 'b'},
  {"version", no_argument, NULL, 'V'},
  {"wide", no_argument, NULL, 'w'},
  {0, no_argument, 0, 0}
}; 

int main (int argc, char **argv) {
	char base[PATH_MAX];
	int c;
	struct DISASM_TGT *target;

	user_asm = "att";		/* default to ATT syntax */


	while ((c = getopt_long (argc, argv,"pib:m:M:VvCdDlfFahHrRtTxsSj:wE:zgG",
			   long_options, (int *) 0)) != EOF) {
		switch (c) {
		case 0:
		  	break;	
		case 'm':
		  	user_arch = optarg; break;
		case 'b':
		  	user_format = optarg; break;
		case 'M':
		  	//disassembler_options = optarg;
		  	break;
		case 'j':
			user_sec = optarg; break;
		case OPT_ADJVMA:
		  	//adjust_section_vma = parse_vma (optarg, "--adjust-vma");
		  	break;
		case OPT_STARTADDR:
		  	//start_address = parse_vma (optarg, "--start-address");
		  	break;
		case OPT_STOPADDR:
		  	//stop_address = parse_vma (optarg, "--stop-address");
		  	break;
		case OPT_INTEL:
			user_asm = "intel";
			break;
		case 'A':
		  	display_opts |= BOBJ_ASCII; break;
		case 'f':
		  	display_opts |= BOBJ_HDR_FILE; break;
		case 'z':
			ext_arch_opts &= ~IGNORE_NULLS; break;
		case 'd':
		  	disasm_opts |= BOBJ_DISASM_X; break;
		case 'D':
		  	disasm_opts |= BOBJ_DISASM_ALL; break;
		case 's':
		  	display_opts |= BOBJ_SEC_FULL; break;
		case 'x':
		  	display_opts |= BOBJ_HDR_SECTION | BOBJ_HDR_ARCHIVE |
			  		BOBJ_HDR_PRIVATE | BOBJ_HDR_FILE |
					BOBJ_SYM | BOBJ_RELOC;
		  	break;
		case 'r':
			display_opts |= BOBJ_RELOC; break;
		case 'R':
			display_opts |= BOBJ_DYNRELOC; break;
		case 't':
			display_opts |= BOBJ_SYM; break;
		case 'T':
			display_opts |= BOBJ_DYNSYM; break;
		case 'a':
		  	display_opts |= BOBJ_HDR_ARCHIVE; break;
		case 'h':
		  	display_opts |= BOBJ_HDR_SECTION; break;
		case 'g':	/* debug info */
		  	display_opts |= BOBJ_STABS; break;
		case 'G':	/* stabs */
		  	display_opts |= BOBJ_DEBUG;
			break;
		case 'p':
		  	display_opts |= BOBJ_HDR_PRIVATE;
			break;
		case 'V':
		case 'v':
			version();
	  		exit(0);
		case 'i':
			/* print formats, arch and exit */
	  		exit(0);
		case 'E': case OPT_ENDIAN: /*  this is ignored */
		case 'S':	/* with source */
		case 'C': case 'l': case 'w':
		  /* these are irrelevant/not supported, but do not cause errors */
		  break;
		case 'H':
		default:
			usage();
		}
	} 
	/* init bastard */
	if (!sys_find_base(base, PATH_MAX, argv))
		return (-1);

	sys_init(base);
	target = env_get_target();
	env_set_option( "DONT_SAVE" );
	env_set_option( "QUIET" );

      if (optind == argc)
		target_load( "a.out");
      else
		target_load(argv[optind]);
	

	/* set assembler type */
	strncpy(target->format.name, user_asm, 15);
	target_set_asm(target->assembler.name, 0);

	if ( user_format ) {
		strncpy(target->format.name, user_format, 15);
		target_set_format(target->format.name, 0);
	}

	if ( user_arch ) {
		strncpy(target->arch.name, user_arch, 31);
	}
	/* set options */
	target_set_arch(target->arch.name, ext_arch_opts);

	/* apply file header first */
	target_apply_format();

	/* display any file info before disassembly */
	if ( display_opts ) {
		do_section_display();
	}

	/* now do the disassembly */
	if ( disasm_opts ) {
		do_disassembly();
	}

	/* finally, show any strings */
	if ( display_opts & BOBJ_ASCII ) {
		do_strings();
	}
	
	/* close bastard */
	target_close_db();
	sys_quit();

	return(0);
}
