#include <stdio.h>
#include <stdlib.h>

#include "ui.h"


/* internal display structs */
struct UI_MENUBAR {
	WINDOW *w;
	int ctext;
	int chigh;
};
struct UI_STATUSBAR {
	WINDOW *w;
	int ctext;
	char left[25];
	char center[30];
	char right[25];
};
struct UI_ASMWIN {
	WINDOW *w;
	int ctext;
	int chigh;
	int caddr;
	int cinsn;
	int creg;
	int ccmt;
	int cname;
	int cfunc;
	int cxref;
};
struct UI_INTWIN {
	WINDOW *w;
	int ctext;
	int chigh;
	int caddr;
	int cinsn;
	int creg;
	int ccmt;
	int cname;
	int cfunc;
};
struct UI_HEXWIN {
	WINDOW *w;
	int ctext;
	int chigh;
};
struct UI_DBWIN {
	WINDOW *w;
	int cdata;
	int chigh;
	int cdesc;
	int ctext;
};
struct UI_HELPWIN {
	WINDOW *w;
	int ctext;
};
struct UI_CONSOLE {
	WINDOW *w;
	int cprompt;
	int ctext;
};
struct UI_DISPLAY {
	WINDOW *data;	/* data window on top */
	WINDOW *active;	/* receiving user input */
	struct UI_MENUBAR menu;
	struct UI_STATUSBAR stat;
	struct UI_ASMWIN asmw;
	struct UI_INTWIN intw;
	struct UI_HEXWIN hexw;
	struct UI_DBWIN dbw;
	struct UI_HELPWIN help;
	struct UI_CONSOLE cons;
} display;

int ui_paint_menubar(){
	wattron( stdscr, display.menu.ctext );
	mvprintw(2,0, "left" );
	mvprintw(0, COLS - strlen("right"), "right" );
	wrefresh( stdscr );
	return(1);
}

int ui_paint_statbar(){
	wattron( stdscr, display.stat.ctext );
	mvprintw(0,0, "left" );
	mvprintw(0, COLS - strlen("right"), "right" );
	wrefresh( stdscr );

	return(1);
}

int ui_paint_data(){
	/* paint topmost data window */
	return(1);
}

int ui_paint_cons(){
	return(1);
}

int ui_init(int tty){
	int start = 0;

	initscr();
	
	if (has_colors()){
		start_color();
		init_pair( 1, COLOR_WHITE, COLOR_BLACK);
		init_pair( 2, COLOR_CYAN, COLOR_BLUE);
		init_pair( 3, COLOR_BLUE, COLOR_CYAN);
		init_pair( 4, COLOR_YELLOW, COLOR_BLACK);
		init_pair( 5, COLOR_RED, COLOR_BLACK);
		init_pair( 6, COLOR_CYAN, COLOR_BLACK);
		init_pair( 7, COLOR_GREEN, COLOR_BLACK);
		init_pair( 8, COLOR_BLUE, COLOR_BLACK);
		init_pair( 9, COLOR_BLACK, COLOR_WHITE);
		init_pair( 10, COLOR_BLACK, COLOR_YELLOW);

	display.menu.ctext = 2;
	display.menu.chigh = 3;
	display.stat.ctext = 3;
	display.asmw.ctext = 1;
	display.asmw.chigh = 9;
	display.asmw.caddr = 4;
	display.asmw.cinsn = 6;
	display.asmw.creg  = 7;
	display.asmw.ccmt  = 8;
	display.asmw.cname = 5;
	display.asmw.cfunc = 5;
	display.asmw.cxref = 8;
	display.intw.ctext = 1;
	display.intw.chigh = 9;
	display.intw.caddr = 4;
	display.intw.cinsn = 6;
	display.intw.creg  = 7; 
	display.intw.ccmt  = 8;
	display.intw.cname = 5;
	display.intw.cfunc = 5;
	display.hexw.ctext = 4;
	display.hexw.chigh = 10;
	display.dbw.cdata  = 4;
	display.dbw.chigh  = 9;
	display.dbw.cdesc  = 6;
	display.dbw.ctext  = 1;
	display.help.ctext = 2;
	display.cons.cprompt = 1;
	display.cons.ctext = 9;
	} 

	ui_refresh();
	return(1);
}

int ui_refresh() {
	ui_paint_menubar();
	ui_paint_statbar();
	ui_paint_data();
	ui_paint_cons();
	refresh();
	return(1);
}
int ui_exit(){
	endwin();
	return(1);
}
