#include <api/api_main.h>

extern struct DISASM_TGT target;
extern struct DISASM_ENV disasm_env;
extern struct DISASM_PREFS disasm_prefs;

/* API sections:
 *    14. Xrefs               :: Address cross-references
 */


/* ---------------------------------------------------------------XRefs */
long xref_to(long rva, int type)
{
	/* returns first xref */
	int cont;
	struct xref x;
	struct xref_to_rva xt = { 0 };

	xt.to_rva = rva;	
	cont = bdb_find_closest_next( XREF_TO_RVA, &xt, &x );
	while( cont ) {
		if ( ! type || x.type & type)
			return(x.from_rva);
		cont = bdb_index_next( XREF_TO_RVA, &x );
	}
	return (sys_set_lasterr(5320));
}

long xref_to_next(int type)
{
	struct xref x;

	if (d_keynext(XREF_TO_RVA) == S_OKAY) {
		d_recread(&x);
		while (type && !(x.type & type)) {
			if (d_keynext(XREF_TO_RVA) != S_OKAY)
				return (0);
			d_recread(&x);
		}
		return (x.from_rva);
	}
	return (0);
}

long xref_from(long rva, int type)
{
	int cont;
	struct xref x;
	struct xref_from_rva xf = { 0 };

	xf.from_rva = rva;	
	cont = bdb_find_closest_next( XREF_FROM_RVA, &xf, &x );
	while( cont ) {
		if ( ! type || (x.type & type))
			return(x.to_rva);
		cont = bdb_index_next( XREF_FROM_RVA, &x );
	}
	return (sys_set_lasterr(5300));
}

long xref_from_next(int type)
{
	struct xref x;

	if (d_keynext(XREF_FROM_RVA) == S_OKAY) {
		d_recread(&x);
		while (type && !(x.type & type)) {
			if (d_keynext(XREF_FROM_RVA) != S_OKAY)
				return (0);
			d_recread(&x);
		}
		return (x.to_rva);
	}
	return (0);
}

int xref_new(long from, long to, int type)
{
	struct xref x;
	struct xref_from_rva xf = { from, to };

	/* check if xref exists */

	if ( bdb_index_find( XREF_FROM_RVA, &xf, &x ) ) {
		if ( ! x.type & type )  {
			x.type |= type;
			bdb_record_update(XREF_ID, &x.id, &x);
		}
		return(1);
	} 

	x.from_rva = from;
	x.to_rva = to;
	x.type = type;
	return( bdb_record_insert( XREF, &x ) );
}

/* =============================================================================================== Sysref stuff */
/* Note: sysrefs are included here due to their similarity to xrefs. */

/* Create a new sysref entry */
int sysref_new( int type, int ref, unsigned long rva ){
	struct sysref s;
	struct sysref_from sf = { rva, type };

	if ( bdb_index_find( SYSREF_FROM, &sf, &s ) ) {
		return( s.id );
	}
	s.type = type;
	s.ref = ref;
	s.rva = rva;
	return( bdb_record_insert(SYSREF, &s) );
}

/* call EXT_OS to build a sysref from CODE struct */
int sysref_fromcode( struct code *c) {
	struct sysref s;

	if ( ext_sysref_gen( c, &s) ){
		return( sysref_new( s.type, s.ref, s.rva) );
	}
	return(0);
}

/* return ID of sysref for given RVA */
int sysref_from( unsigned long rva) {
	struct sysref s;
	struct sysref_from sf = { rva, 0 };

	if ( bdb_find_closest_next( SYSREF_FROM, &sf, &s ) ) {
		if ( s.rva == rva )
			return( s.id );
	}
	return(0);
}

int sysref_get_type( int id ) {
	struct sysref s;

	if ( ! bdb_index_find( SYSREF_ID, &id, &s ) ) {
		return(0);
	}
	return( s.type );
}

int sysref_get_subtype( int id ) {
	struct sysref s;

	if ( ! bdb_index_find( SYSREF_ID, &id, &s ) ) {
		return(0);
	}
	return( s.subtype );
}

int sysref_get_name( int id, char *buf, int len ) {
	struct sysref s;

	if ( ! bdb_index_find( SYSREF_ID, &id, &s ) ) {
		return(0);
	}
	return( ext_sysref_name( &s, buf, len) );
}

int sysref_sprint( struct sysref *s, char *buf, int len){

	if (! s || ! buf) return(0);
	switch ( s->type ) {
		case SYSREF_SYSCALL:
			sysref_get_name( s->id, buf, len );
			strncat( buf, "()", len - strlen(buf) - 1);
			break;
		case SYSREF_EXCEPTION:
		case SYSREF_TRAP:
		case SYSREF_DEVICE:
		default:
			break;
	}
	return(strlen(buf));
}
