/* api.c : part of The Bastard disassembly environment ========================G
 *
 * Contains  the bulk of the internal code -- specifically, the API routines
 * provided for internal and scripting use. Functions should be in the same
 * order as in api.h
 */
#include <api/api_main.h>

extern struct DISASM_TGT target;
extern struct DISASM_ENV disasm_env;
extern struct DISASM_PREFS disasm_prefs;

/* API sections:
 *    10. Structures            :: User-defined data structures
 *    13. Constants            :: User-defined constants/enums
 */


/* ---------------------------------------------------------------Data Types */

int dtype_new(char *name, int size, int flags)
{
	/* this is essentially a typedef */
	struct data_type d = {0};

	/* 2. add new data_type record */
	d.flags = flags;
	d.size = size;
	strncpy(d.name, name, 32);
	disasm_env.flags |= DB_MOD;
	if (bdb_record_insert(DATA_TYPE, &d))
		return (d.id);
	return (0);
}

int dtype_del(char *name)
{
	struct data_type d;

	disasm_env.flags |= DB_MOD;
	if (bdb_index_find(DATA_TYPE_NAME, name, &d))
		return (bdb_record_delete(DATA_TYPE, &d.id));
	return (0);
}

int dtype_copy(char *name, char *new_name);
int dtype_get(char *name)
{
	struct data_type d;

	if (bdb_index_find(DATA_TYPE_NAME, name, &d))
		return (d.id);
	return (0);
}


/* ---------------------------------------------------------------Structures */
int struct_new(char *name, short size)
{
	struct structure s = {0};

	s.size = size;
	strncpy(s.name, name, 32);
	disasm_env.flags |= DB_MOD;
	if (bdb_record_insert(STRUCTURE, &s))
		return (s.id);
	return (0);
}

int struct_add_member(int struct_id, long type, int size, int order, char *name)
{
	/* type = id of data type     order = field # in structure */
	/* size = # of data types [e.g. >1 == array ] */
	struct struct_member s ={0};

	s.structure = struct_id;
	s.type = type;
	s.size = size;
	s.order = order;
	strncpy(s.name, name, 32);
	disasm_env.flags |= DB_MOD;
	if (bdb_record_insert(STRUCT_MEMBER, &s))
		return (s.id);
	return (-1);
}
int struct_get(unsigned long id, struct structure *s)
{
// fills structure 
	return (0);
}
unsigned long struct_get_id(char *name)
{
	return (0);
}
int struct_get_member(int struct_id, int order, struct struct_member *m)
{
// m.id and m.order must be filled before calling this
	return (0);
}

/* this is considered an "internal" function */
int struct_apply_member(long rva, struct structure *s, struct struct_member *m, 
							char *base_name)
{
	struct data_type d;
	char buf[64];
	int size;

	if (!bdb_index_find(DATA_TYPE_ID, &m->type, &d)){
		return (sys_set_lasterr(0));
	}
	
	/* get total size of structure member, create ADDRESS for it */
	size = m->size * d.size;
	addr_new(rva, size, ADDR_UNK_PA, ADDR_DATA);
	snprintf( buf, 64, "%s.%s", base_name, m->name );
	name_new(rva, buf, NAME_AUTO | NAME_STRUCT);

	return (size);
}

int struct_apply(long rva, unsigned long id)
{
// This basically just sets addr.structre to s
	struct address a;
	struct structure s;
	struct struct_member m;
	struct struct_member_struct sm = {0};
	unsigned long c_id;
	char buf[128];
	void *state;
	int cont;

	if (! bdb_index_find(STRUCTURE_ID, &id, &s) )
		return (sys_set_lasterr(0));

	/* Force ADDRESS to structure.size, get new ADDRESS object */
	addr_new(rva, s.size, ADDR_UNK_PA, ADDR_DATA | ADDR_STRUCT);
	
	/* create comment for address */
	snprintf( buf, 128, "structure %s", s.name);
	c_id = comment_new(buf, CMT_AUTO);
	
	
	if ( d_keyfind(ADDRESS_RVA, &rva) == S_OKAY &&
			d_recread(&a) == S_OKAY ) {
			/* link address to structure */
		a.structure = id;
		if (! a.comment)
			a.comment = c_id;
		d_recwrite(&a);
	}
	
	if ( ! name_get( rva, buf ) ) {
		sprintf(buf, "struct_%08X", rva );
		name_new(rva, buf, NAME_AUTO | NAME_STRUCT); 
	}

	/* for each structure member, create/name an ADDRESS object */
	sm.structure = id;
	cont = bdb_find_closest_next(STRUCT_MEMBER_STRUCT, &sm, &m);
	while (cont && m.structure == id) {
		state = db_save_state();
		rva += struct_apply_member(rva, &s, &m, buf);
		db_restore_state(state);
		cont = bdb_index_next(STRUCT_MEMBER_STRUCT, &m);
	}

	disasm_env.flags |= DB_MOD;

	return (1);
}
int struct_del(unsigned long id)
{
	disasm_env.flags |= DB_MOD;
// s = structure ID 
	return (0);
}
int struct_member_del(unsigned long id)
{
	disasm_env.flags |= DB_MOD;
// s = struct_member id
	return (0);
}
/* ---------------------------------------------------------------Constants */
unsigned long const_new(char *name, int value, unsigned long group)
{
/* redefines existing */
	struct constant c;

	if (d_keyfind(CONSTANT_NAME, name) == S_OKAY) {
		d_recread(&c);
		c.value = value;
		c.group = group;
		d_recwrite(&c);
	} else {
		strncpy(c.name, name, 31);
		c.name[31] = 0;
		c.value = value;
		c.group = group;
		bdb_record_insert(CONSTANT, &c);
	}

	if (db_status != S_OKAY)
		return (sys_set_lasterr(db_error()));
	return (c.id);
}

int const_get_by_val(int value, char *buf, int len)
{
	struct constant c;

	if (d_keyfind(VALUE, &value) == S_OKAY) {
		d_recread(&c);
		strncpy(buf, c.name,len);
		return (c.id);
	}
	return (sys_set_lasterr(5120));
}

/*int const_get_by_valNext(char buf[32]){
   struct constant c;
   
   if ( d_keynext(VALUE) == S_OKAY) {
      d_recread(&c);
      strcpy(buf, c.name);
      return(c.id);
   }
   return(0);
}*/
int const_val(unsigned long id)
{
	struct constant c;

	if (d_keyfind(CONSTANT_ID, &id) == S_OKAY) {
		d_recread(&c);
		return (c.value);
	}
	return (sys_set_lasterr(5100));
}



int const_get_name(unsigned long id, char *buf, int len)
{
// get name into buf[32]
	struct constant c;

	if (d_keyfind(CONSTANT_ID, &id) == S_OKAY) {
		d_recread(&c);
		strncpy(buf, c.name, len);
		return (strlen(c.name));
	}
	return (sys_set_lasterr(5100));
}

unsigned long const_get_by_name(char *name)
{
	/* constants are unique by name/id, but not by value */
	struct constant c;

	if (d_keyfind(CONSTANT_NAME, name) == S_OKAY) {
		d_recread(&c);
		return (c.id);
	}
	return (sys_set_lasterr(5110));
}

int const_del(unsigned long id)
{
	if (!bdb_record_delete(CONSTANT_ID, &id))
		return (sys_set_lasterr(5100));
	disasm_env.flags |= DB_MOD;
	return (1);
}

int const_apply(unsigned long id, unsigned long rva) {
	struct address a;
	void *state;
	int rv = 0;
	
	state = db_save_state();
	if ( d_keyfind( ADDRESS_RVA, &rva ) == S_OKAY ) {
		d_recread( &a );
		a.dataConst = id;
		d_recwrite( &a );
		rv = 1;
	}
	
	db_restore_state(state);
	return(rv);
}
unsigned long const_val_in_group( unsigned long group, int value );
unsigned long const_group_new( char *name );
unsigned long const_group_del( unsigned long id );
unsigned long const_group_by_name( char *name );
int const_group_get_name( unsigned long id, char *buf, int len );

