#include <api/api_main.h>
#include <extension.h>

extern struct DISASM_TGT target;
extern struct DISASM_ENV disasm_env;
extern struct DISASM_PREFS disasm_prefs;

/* API sections:
 *    16. Macros               :: User-defined/recorded EiC scripts
 */

/* NOTE: These functions are redundant with ones macro.c and should replace them */
/* ---------------------------------------------------------------Macros */
int script_text_exec(char *cmd)
{
	return (sys_exec_macro_line(cmd));

}

int script_file_exec(char *name)
{
	//LoadExtension( name, EXT_SCRIPT, ext_script );
	//return( ext_script->fn_main(0, NULL) );
	struct stat s;
	int len;
	char *path, tmp[PATH_MAX];

	if (name[0] == '"') {	/* remove quotes if they exist */
		len = strlen(name);
		name[len - 1] = '\0';
		name++;
	}
	if (stat(name, &s)) {
		sprintf(tmp, "%s/scripts/%s", disasm_env.share, name);
		if (stat(tmp, &s))
			// return(macro_exec)...
			return (0);
		path = tmp;
	} else {
		path = name;
	}
	return (sys_exec_script(path, 0, NULL));
}

/* OBSOLETE !! */
int script_compiled_exec(char *name)
{
	return (0);
}

/* OBSOLETE !! */
int script_compile(char *name)
{
	/* This calls the external BC compiler to compile a .bc [EiC source]
	 * script to a .bx [EiC bytecode] bytecode file */
	return (1);
}


   /* MACROs stored in the DB 
    * TODO -- we need some provision for saving this
    * across databases */

int macro_new(char *name, char *macro)
{
	struct bc_macro m;

	memset(&m, 0, sizeof (struct bc_macro));
	strncpy(m.name, name, 31);
	m.id = ++seq.bc_macro;
	m.name[31] = 0;
	if (strlen(macro) > 2047) {
		m.type = 2;

		/* write to file in $HOME/scripts/macros */
	} else {
		m.type = 1;
		strcpy(m.macro, macro);
	}
	if (d_fillnew(BC_MACRO, &m) != S_OKAY)
		return (sys_set_lasterr(db_error()));
	return (m.id);

}

int macro_del(char *name)
{
	disasm_env.flags |= DB_MOD;
	if (bdb_record_delete(BC_MACRO_NAME, name))
		return (1);
	return (sys_set_lasterr(4601));
}

int macro_exec(char *name)
{
	/* if type 1, compile macro */
	/* if type 2, read file and compile macro */
	sys_exec_script(name);
	/* run EiC script */

}
int macro_record(char *name)
{
	struct bc_macro m;
	/* 'enter xxx to exit' */
	/* while !xxx */
	/* gets, add to buff[2048] */
	/* macro_new */

}
