#include <api/api_main.h>

extern struct DISASM_TGT target;
extern struct DISASM_ENV disasm_env;
extern struct DISASM_PREFS disasm_prefs;

/* API sections: 
 *     8. Imports               :: Creating/manipulating IMPORT objects
 *     9. Exports               :: Creating/manipulating EXPORT objects
 * /

/* ---------------------------------------------------------------Imports */
imp_new(long rva, char *lib, char *name, int type)
{
	struct import_addr imp = {0};
	struct name n = {0};
	struct lib l = {0};

	if (d_keyfind(IMPORT_ADDR_RVA, &rva) == S_OKAY) {
		return (1);
	} else {
		/* make new NAME for name */
		func_new(rva, name, 4, NAME_SYMBOL | NAME_AUTO);
		addr_set_flags(rva,
			       ADDR_CODE | ADDR_IMPORT | ADDR_FUNCTION |
			       ADDR_SYMBOL);

		imp.rva = rva;
		l.id = 0;
		if (lib) {
			if (d_keyfind(LIB_NAME, lib) == S_OKAY)
				d_recread(&l);
			else {
				lib_new(lib, 0, 0);
				if (d_keyfind(LIB_NAME, lib) == S_OKAY)
					d_recread(&l);
				else
					return (0);	/* error will be set by Define Library */
			}
		}
		imp.library = l.id;
		imp.type = type;
		d_fillnew(IMPORT_ADDR, &imp);
		if (db_status != S_OKAY)
			return (sys_set_lasterr(db_error()));
	}
	disasm_env.flags |= DB_MOD;
	return (1);
}

int imp_get_name(long rva, char *buf)
{
	if (d_keyfind(IMPORT_ADDR_RVA, &rva) != S_OKAY)
		return (sys_set_lasterr(4400));
	return (name_get(rva, buf));
}

int imp_get_lib(long rva, char *buf)
{
	struct import_addr i;
	struct lib l;

	if (d_keyfind(IMPORT_ADDR_RVA, &rva) != S_OKAY)
		return (sys_set_lasterr(4400));
	d_recread(&i);
	return (i.library);
}

int imp_type(long rva)
{
	struct import_addr i;

	if (d_keyfind(IMPORT_ADDR_RVA, &rva) != S_OKAY)
		return (sys_set_lasterr(4400));
	d_recread(&i);
	return (i.type);
}

int lib_new(char *name, int v_hi, int v_lo)
{
	struct lib l;
	if (d_keyfind(LIB_NAME, &name) == S_OKAY)
		return (sys_set_lasterr(4410));
	strncpy(l.name, name, 63);
	l.ver_hi = v_hi;
	l.ver_lo = v_lo;
	l.id = ++seq.library;
	d_fillnew(LIB, &l);
	if (db_status != S_OKAY)
		return (sys_set_lasterr(db_error()));
	return (1);
}
int imp_print()
{
	struct import_addr i;
	struct name n;

	d_keyfrst(IMPORT_ADDR_RVA);
	while (db_status == S_OKAY) {
		d_recread(&i);
		if (d_keyfind(NAME_RVA, &i.rva) == S_OKAY) {
			d_recread(&n);
			printf("%x %s\n", i.rva, n.text);
		}
		d_keynext(IMPORT_ADDR_RVA);
	}
	return (1);
}

int lib_print()
{
	struct lib l;

	d_keyfrst(LIB_ID);
	while (db_status == S_OKAY) {
		d_recread(&l);
		printf("%s %d.%d\n", l.name, l.ver_hi, l.ver_lo);
		d_keynext(LIB_ID);
	}
	return (1);
}				/* print all libraries to stdout */

/* ---------------------------------------------------------------Exports */
int exp_new(long rva, char *name)
{
	struct export_addr e;
	struct name n;

	/* do nothing if it already exists */
	if (d_keyfind(EXPORT_ADDR_RVA, &rva) == S_OKAY) {
		return (1);
	}
	/* make new NAME for name */
	name_new(rva, name, NAME_SYMBOL | NAME_AUTO);

	e.rva = rva;
	if (d_fillnew(EXPORT_ADDR, &e) == S_OKAY)
		return (1);
	return (sys_set_lasterr(db_error()));
}

int exp_get(char *name)
{
	struct export_addr e;
	int rva;

	rva = addr_get_by_name(name);
	if (d_keyfind(EXPORT_ADDR_RVA, &rva) != S_OKAY) {
		return (sys_set_lasterr(4451));
	}
	return (rva);
}

int exp_print()
{
	struct export_addr e;
	struct name n;

	d_keyfrst(EXPORT_ADDR_RVA);
	while (db_status == S_OKAY) {
		d_recread(&e);
		printf("%x", e.rva);
		if (d_keyfind(NAME_RVA, &e.rva) == S_OKAY) {
			d_recread(&n);
			printf("\t%s", n.text);
		}
		printf("\n");
		d_keynext(EXPORT_ADDR_RVA);
	}
	return (1);
}
