{{
	struct DISASM_TGT *t;
	char buf[PATH_MAX];

	t = env_get_target();
	if ( t->info.name[0] ) {
            sprintf( buf, "%s/%s", t->info.path, t->info.name );
		target_load(buf);
	}
	/* dammit! we cannot call target_apply_format from a {{ block */
}}
target_set_format( "ELF", 0 );
target_set_arch( "i386", 0 );
target_set_asm( "intel", 0 );
target_set_lang( "C", 0 );
target_set_comp( "gcc", 0 );
target_set_os( "linux", 0 );
target_apply_format();
{{
	struct DISASM_TGT *t;
	struct section s;
	struct address a;
	struct code c;
	int a_exist, c_exist, cont;

	t = env_get_target();
	disasm_forward(t->info.entry);
	/* foreach code section */
	cont = bdb_table_first( SECTION, &s );
	while ( cont ) {
		if ( (s.flags & SECTION_TYPE_MASK) == SECTION_CODE ) {
			printf("doing section %s)\n", s.name);
			/* foreach address */
			a_exist = bdb_index_find(ADDRESS_RVA, &s.rva, &a);
			while ( a_exist && a.rva < s.rva + s.size ) {
				c_exist = bdb_index_find(CODE_RVA, &a.rva, &c);
				if (! c_exist ) {
					printf("%d bytes dead code at file offset %08X\n",
					  	a.size, a.pa );
				}
				a_exist = bdb_index_next(ADDRESS_RVA, &a);	
			} /* end while */
		}
		cont = bdb_table_next(SECTION, &s);
	}	/* end while */
}}
q
