/*  A S M    E X T E NS I O N  */

#ifndef EXT_ASM_H
#define EXT_ASM_H

#include <extension.h>

#define ASM_OUTPUT_TTY       0x00
#define ASM_OUTPUT_FILE      0x01
#define ASM_OUTPUT_PRINTER   0x02
#define ASM_OUTPUT_TTY_COLOR 0x03


typedef int (*sprintaddrexp_fn)(char *, int, char *, char *, char *, char *, int);
typedef int (*sprintcode_fn)(long, char *, int, int);
typedef int (*sprintsec_fn)(char *, int, char *);
typedef int (*sprintfunc_fn)(char *, int, int);
typedef int (*sprintstruct_fn)(char *, int, long);
typedef int (*genasmfile_fn)(FILE *);
struct EXT__ASM {             /* target assembler */
   struct EXTENSION ext;
   int options;
   /* settings */
   char *comment;          /* comment character/string */
   char *reg_pre;          /* register prefix string */
   char *imm_pre;          /* immediate value prefix string */
   char *local_pre;        /* local label value prefix string */
   /* format strings */
   char *asm_ttyColor;         /* assume 80 col, use coor escape seq's */
   char *asm_ttyMono;          /* assume 80 col, no escape seq's */
   char *asm_file;             /* no line length */
   char *asm_lpr;              /* no line length */
   char *data_ttyColor;        /* assume 80 col, use coor escape seq's */
   char *data_ttyMono;         /* assume 80 col, no escape seq's */
   char *data_file;            /* no line length */
   char *data_lpr;             /* no line length */
   /* function pointers */
   sprintcode_fn      fn_sprint_code;  /* fix reg, addr, mnems */
   sprintaddrexp_fn   fn_sprint_addrexp;  /* sprint the address expression */
   sprintfunc_fn      fn_sprint_func_s;
   sprintfunc_fn      fn_sprint_func_e;
   sprintstruct_fn    fn_sprint_struct;
   sprintsec_fn       fn_sprint_sec_s;      /* declare section */
   sprintsec_fn       fn_sprint_sec_e;      /* declare section */
   genasmfile_fn      fn_gen_file;
} ;
extern struct EXT__ASM *ext_asm;

/* Private Parts ;)  */
	#ifndef INCLUDED_FROM_BASTARD_H

	#endif

#endif
