#ifndef BASTARD_DB_INT_H
#define BASTARD_DB_INT_H


/* this is internal stuff */

struct DB_SEQUENCE {
	int addr_exp;
	int code_effect;
	int reg_state;
	int sysref;
	int int_code;
	int fin_code;
	int xref;
	int name;
	int comment;
	int func;
	int func_param;
	int func_local;
	int func_effect;
	int f_inline;
	int structure;
	int struct_member;
	int data_type;
	int library;
	int constant;
	int const_group;
	int bc_macro;
};
extern struct DB_SEQUENCE seq;

struct db_table;			/* this is really declared in db_query */
struct DB_TBLDESC {
	int *seq;				/* pointer to sequence */
	struct db_table *db_table;	/* indexed link to db_query structure */
};


struct DB_DESCRIPTOR {
   int db_id;
   char name[64];
   char filename[256];
   struct DB_DESCRIPTOR *prev;
   struct DB_DESCRIPTOR *next;
};

extern struct DB_DESCRIPTOR *db_head, *db_current, *db_config, *db_target;

struct BDB_ITERATOR {
	int index;
	int db_state;
	BDB_ITERATOR_FN func;
	void *arg;
};

int db_init();
void db_init_seq();
int db_load( char *dbname, char *filename, struct DB_DESCRIPTOR *db );
int db_switch( int db );
int db_unload(struct DB_DESCRIPTOR *db);
int db_error();
void db_error_msg( );

#endif
