#ifndef BASTARD_DB_BDB_H
#define BASTARD_DB_BDB_H

/* BDB Database-specific Interface -- db.c
   ======================================================================== */

   typedef int (*BDB_ITERATOR_FN)(void *record, void *arg);

   /* The iterator provides a guaranteed mechanism for iterating through
    * the records of a table or index. The state is restored during each
    * call to bdb_iterator_next, and is slightly faster than calling
    * db_save_state() and db_restore_state() since calloc() is only
    * called in bdb_iterator_new() 
    *
    * Usage:
    * 	void *i = bdb_iterator_new( index, NULL, NULL );
    * 	while( bdb_iterator_next( i, &buf ) ) {
    * 		...
    * 	}
    * 	bdb_iterator_free( i );
    *
    * Note that "func" is a callback which receives the current record
    * and "arg" as parameters; it is expected to return 0 or 1 if the
    * record is to be skipped or returned by bdb_iterator_next(). The
    * intent is to allow the user to provide a comparison function, such
    * that only records which match a certain criteria will be returned
    * by bdb_iterator_next() ... a crude SELECT statement.
    */
   void * bdb_iterator_new(int index, BDB_ITERATOR_FN func, void *arg);
   int bdb_iterator_next(void *it, void *dest);
   int bdb_iterator_free(void *it);

   /*   These expect *dest to be pre-allocated */
   int bdb_index_first(int index, void *dest);
   int bdb_index_next(int index, void *dest);
   int bdb_index_prev(int index, void *dest);
   int bdb_index_last(int index, void *dest);
   int bdb_index_find(int index, void *value, void *dest);
   int bdb_table_first(int table, void *dest);
   int bdb_table_next(int table, void *dest);
   int bdb_table_prev(int table, void *dest);
   int bdb_table_last(int table, void *dest);
   int bdb_record_insert(int table, void *src);
   int bdb_record_update(int index, void *value, void *src);
   int bdb_record_delete(int index, void *value);
   int bdb_find_closest_prev(int index, void *value, void *dest);
   int bdb_find_closest_next(int index, void *value, void *dest);
   int bdb_table_count(int table);

   /* warning: do not call this from scripts! EiC is not re-entrant */
   void bdb_index_foreach(int index, BAPI_CALLBACK func, void *data);

#endif
