#ifndef BASTARD_DB_MAIN_H
#define BASTARD_DB_MAIN_H

#include <ctype.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
/* bastard includes */
#include <bastard.h>		/* for the typedef */
#include <bdb.h>			/* for the DB structures */
#include <db/db_bdb.h>		/* for operations on BDB databases */
#include <db/db_int.h>		/* for the internal stuff */
#include <db/db_query.h>	

/* DB Interface -- db.c
   ======================================================================== */

/* DB State -- a way to keep the DB from changing the current record inside
 *             a subroutine. Wrap all calls to the DB as follows:
 *
 * 			int state = db_save_state();
 * 			...
 * 			db_restore_state(state);
 *
 *             and you should be alright. */
   void * db_save_state(void);
   int db_restore_state(void * state);


   /* ---- generic 'object' access ---- */
   /*   These calloc a struct and fill it; it is up to the caller to free */
   struct address * GetAddressObject(long rva);
   struct code * GetCodeObject(long rva);
   struct addr_exp * GetAddrExpObject(int id);
   struct code_effect * GetCodeEffectObject(int id);
   struct section * GetSectionObject(char *name);
   struct xref * GetXrefObject(int id);
   struct int_code * GetIntCodeObject(int id);
   struct fin_code * GetFinCodeObject(int id);
   struct export_addr * GetExportObject(long rva);
   struct import_addr * GetImportObject(long rva);
   struct string * GetStringObject(long rva);
   struct name * GetNameObject(long rva);
   struct comment * GetCommentObject(int id);
   struct function * GetFunctionObject(int id);
   struct func_param * GetFuncParamObject(int id);
   struct func_local * GetFuncLocalObject(int id);
   struct func_effect * GetFuncEffectObject(int id);
   struct f_inline * GetFInlineObject(int id);
   struct structure * GetStructureObject(int id);
   struct struct_member * GetStructMemberObject(int id);
   struct data_type * GetDataTypeObject(int id);
   struct constant * GetConstantObject(int id);
   struct bc_macro * GetBCMacroObject(int id);

	#ifndef INCLUDED_FROM_BASTARD_H
		#include <db/typhoon.h>
	#endif

#endif
