#ifndef BDB_H 
#define BDB_H 
/*---------- headerfile for src/bdb.ddl ----------*/
/* alignment is 4 */

/*---------- structures ----------*/
struct address {  /* size 38 */
    unsigned long    rva;
    unsigned long    pa;
    unsigned short   size;
    unsigned long    flags;
    unsigned long    dataType;
    int     dataSize;
    unsigned long    dataConst;
    unsigned long    structure;
    unsigned long    comment;
    unsigned short   tag;
};

struct section {  /* size 46 */
    char    name[32];
    unsigned long    rva;
    unsigned long    size;
    unsigned long    flags;
    unsigned short   tag;
};

struct xref {  /* size 16 */
    unsigned long    id;
    unsigned long    from_rva;
    unsigned long    to_rva;
    unsigned long    type;
};

struct xref_from_rva {  /* size 8 */
    unsigned long    from_rva;
    unsigned long    to_rva;
};

struct xref_to_rva {  /* size 8 */
    unsigned long    to_rva;
    unsigned long    from_rva;
};

struct code {  /* size 54 */
    unsigned long    rva;
    unsigned long    func;
    char    mnemonic[16];
    long    dest;
    long    src;
    long    aux;
    unsigned int     mnemType;
    unsigned int     destType;
    unsigned int     srcType;
    unsigned int     auxType;
    unsigned short   tag;
};

struct code_function {  /* size 8 */
    unsigned long    func;
    unsigned long    rva;
};

struct code_dest_op {  /* size 8 */
    long    dest;
    unsigned long    rva;
};

struct code_src_op {  /* size 8 */
    long    src;
    unsigned long    rva;
};

struct code_mnemonic {  /* size 20 */
    char    mnemonic[16];
    unsigned long    rva;
};

struct addr_exp {  /* size 28 */
    unsigned long    id;
    int     scale;
    int     index;
    int     base;
    long    disp;
    unsigned long    flags;
    unsigned long    name;
};

struct code_effect {  /* size 24 */
    unsigned long    id;
    unsigned long    rva;
    int     loc;
    unsigned long    type;
    unsigned long    change;
    int     amount;
};

struct code_effect_rvaid {  /* size 8 */
    unsigned long    rva;
    unsigned long    id;
};

struct reg_state {  /* size 20 */
    unsigned long    id;
    int     reg;
    unsigned long    val;
    int     reftype;
    unsigned long    ref;
};

struct reg_state_by_ref {  /* size 12 */
    unsigned long    ref;
    int     reftype;
    int     reg;
};

struct sysref {  /* size 20 */
    unsigned long    id;
    int     type;
    int     subtype;
    int     ref;
    unsigned long    rva;
};

struct sysref_type_id {  /* size 12 */
    int     type;
    int     ref;
    unsigned long    id;
};

struct sysref_from {  /* size 8 */
    unsigned long    rva;
    int     type;
};

struct int_code {  /* size 50 */
    unsigned long    id;
    unsigned long    opcode;
    unsigned long    src;
    unsigned long    sType;
    unsigned long    dest;
    unsigned long    dType;
    unsigned long    arg;
    unsigned long    aType;
    unsigned long    func;
    unsigned long    order;
    unsigned long    rva;
    unsigned long    comment;
    unsigned short   tag;
};

struct fn_order {  /* size 8 */
    unsigned long    func;
    unsigned long    order;
};

struct fin_code {  /* size 270 */
    unsigned long    id;
    unsigned long    rva;
    int     size;
    char    line[256];
    unsigned short   tag;
};

struct export_addr {  /* size 4 */
    unsigned long    rva;
};

struct import_addr {  /* size 12 */
    unsigned long    library;
    unsigned long    type;
    unsigned long    rva;
};

struct import_library {  /* size 8 */
    unsigned long    library;
    unsigned long    rva;
};

struct lib {  /* size 76 */
    unsigned long    id;
    char    name[64];
    int     ver_hi;
    int     ver_lo;
};

struct string {  /* size 264 */
    unsigned long    rva;
    int     length;
    char    text[256];
};

struct name {  /* size 76 */
    unsigned long    id;
    unsigned long    rva;
    unsigned long    type;
    char    text[64];
};

struct comment {  /* size 266 */
    unsigned long    id;
    unsigned long    type;
    char    text[256];
    unsigned short   tag;
};

struct function {  /* size 22 */
    unsigned long    id;
    unsigned long    rva;
    unsigned short   size;
    unsigned long    ret_type;
    unsigned long    comment;
    unsigned short   tag;
};

struct func_param {  /* size 60 */
    unsigned long    id;
    unsigned long    func;
    unsigned long    type;
    int     size;
    unsigned long    addr_exp;
    unsigned long    flags;
    char    name[32];
    unsigned long    const_group;
};

struct func_param_funcid {  /* size 8 */
    unsigned long    func;
    unsigned long    id;
};

struct func_local {  /* size 56 */
    unsigned long    id;
    unsigned long    func;
    unsigned long    type;
    int     size;
    unsigned long    addr_exp;
    unsigned long    flags;
    char    name[32];
};

struct func_local_funcid {  /* size 8 */
    unsigned long    func;
    unsigned long    id;
};

struct func_effect {  /* size 24 */
    unsigned long    id;
    unsigned long    func;
    int     loc;
    unsigned long    type;
    unsigned long    change;
    int     amount;
};

struct func_effect_funcid {  /* size 8 */
    unsigned long    func;
    unsigned long    id;
};

struct f_inline {  /* size 76 */
    unsigned long    id;
    char    name[64];
    unsigned long    rva;
    unsigned short   size;
    unsigned short   tag;
};

struct structure {  /* size 38 */
    unsigned long    id;
    char    name[32];
    unsigned short   size;
};

struct struct_member {  /* size 56 */
    unsigned long    id;
    unsigned long    type;
    int     size;
    unsigned long    structure;
    int     order;
    char    name[32];
    unsigned long    const_group;
};

struct struct_member_struct {  /* size 8 */
    unsigned long    structure;
    int     order;
};

struct data_type {  /* size 44 */
    unsigned long    id;
    int     size;
    unsigned long    flags;
    char    name[32];
};

struct constant {  /* size 44 */
    unsigned long    id;
    char    name[32];
    long    value;
    unsigned long    group;
};

struct constant_group_value {  /* size 8 */
    unsigned long    group;
    long    value;
};

struct constant_group {  /* size 36 */
    unsigned long    id;
    char    name[32];
};

struct bc_macro {  /* size 2088 */
    unsigned long    id;
    unsigned long    type;
    char    name[32];
    char    macro[2048];
};

/*---------- record names ----------*/
#define ADDRESS 1000L
#define SECTION 2000L
#define XREF 3000L
#define CODE 4000L
#define ADDR_EXP 5000L
#define CODE_EFFECT 6000L
#define REG_STATE 7000L
#define SYSREF 8000L
#define INT_CODE 9000L
#define FIN_CODE 10000L
#define EXPORT_ADDR 11000L
#define IMPORT_ADDR 12000L
#define LIB 13000L
#define STRING 14000L
#define NAME 15000L
#define COMMENT 16000L
#define FUNCTION 17000L
#define FUNC_PARAM 18000L
#define FUNC_LOCAL 19000L
#define FUNC_EFFECT 20000L
#define F_INLINE 21000L
#define STRUCTURE 22000L
#define STRUCT_MEMBER 23000L
#define DATA_TYPE 24000L
#define CONSTANT 25000L
#define CONSTANT_GROUP 26000L
#define BC_MACRO 27000L

/*---------- field names ----------*/
#define ADDRESS_RVA 1001L
#define PA 1002L
#define ADDRESS_SIZE 1003L
#define ADDRESS_FLAGS 1004L
#define DATATYPE 1005L
#define DATASIZE 1006L
#define DATACONST 1007L
#define ADDRESS_STRUCTURE 1008L
#define ADDRESS_COMMENT 1009L
#define ADDRESS_TAG 1010L
#define SECTION_NAME 2001L
#define SECTION_RVA 2002L
#define SECTION_SIZE 2003L
#define SECTION_FLAGS 2004L
#define SECTION_TAG 2005L
#define XREF_ID 3001L
#define FROM_RVA 3002L
#define TO_RVA 3003L
#define XREF_TYPE 3004L
#define CODE_RVA 4001L
#define CODE_FUNC 4002L
#define MNEMONIC 4003L
#define CODE_DEST 4004L
#define CODE_SRC 4005L
#define AUX 4006L
#define MNEMTYPE 4007L
#define DESTTYPE 4008L
#define SRCTYPE 4009L
#define AUXTYPE 4010L
#define CODE_TAG 4011L
#define ADDR_EXP_ID 5001L
#define SCALE 5002L
#define INDEX 5003L
#define BASE 5004L
#define DISP 5005L
#define ADDR_EXP_FLAGS 5006L
#define ADDR_EXP_NAME 5007L
#define CODE_EFFECT_ID 6001L
#define CODE_EFFECT_RVA 6002L
#define CODE_EFFECT_LOC 6003L
#define CODE_EFFECT_TYPE 6004L
#define CODE_EFFECT_CHANGE 6005L
#define CODE_EFFECT_AMOUNT 6006L
#define REG_STATE_ID 7001L
#define REG 7002L
#define VAL 7003L
#define REFTYPE 7004L
#define REG_STATE_REF 7005L
#define SYSREF_ID 8001L
#define SYSREF_TYPE 8002L
#define SUBTYPE 8003L
#define SYSREF_REF 8004L
#define SYSREF_RVA 8005L
#define INT_CODE_ID 9001L
#define OPCODE 9002L
#define INT_CODE_SRC 9003L
#define STYPE 9004L
#define INT_CODE_DEST 9005L
#define DTYPE 9006L
#define ARG 9007L
#define ATYPE 9008L
#define INT_CODE_FUNC 9009L
#define INT_CODE_ORDER 9010L
#define INT_CODE_RVA 9011L
#define INT_CODE_COMMENT 9012L
#define INT_CODE_TAG 9013L
#define FIN_CODE_ID 10001L
#define FIN_CODE_RVA 10002L
#define FIN_CODE_SIZE 10003L
#define LINE 10004L
#define FIN_CODE_TAG 10005L
#define EXPORT_ADDR_RVA 11001L
#define LIBRARY 12001L
#define IMPORT_ADDR_TYPE 12002L
#define IMPORT_ADDR_RVA 12003L
#define LIB_ID 13001L
#define LIB_NAME 13002L
#define VER_HI 13003L
#define VER_LO 13004L
#define STRING_RVA 14001L
#define LENGTH 14002L
#define STRING_TEXT 14003L
#define NAME_ID 15001L
#define NAME_RVA 15002L
#define NAME_TYPE 15003L
#define NAME_TEXT 15004L
#define COMMENT_ID 16001L
#define COMMENT_TYPE 16002L
#define COMMENT_TEXT 16003L
#define COMMENT_TAG 16004L
#define FUNCTION_ID 17001L
#define FUNCTION_RVA 17002L
#define FUNCTION_SIZE 17003L
#define RET_TYPE 17004L
#define FUNCTION_COMMENT 17005L
#define FUNCTION_TAG 17006L
#define FUNC_PARAM_ID 18001L
#define FUNC_PARAM_FUNC 18002L
#define FUNC_PARAM_TYPE 18003L
#define FUNC_PARAM_SIZE 18004L
#define FUNC_PARAM_ADDR_EXP 18005L
#define FUNC_PARAM_FLAGS 18006L
#define FUNC_PARAM_NAME 18007L
#define FUNC_PARAM_CONST_GROUP 18008L
#define FUNC_LOCAL_ID 19001L
#define FUNC_LOCAL_FUNC 19002L
#define FUNC_LOCAL_TYPE 19003L
#define FUNC_LOCAL_SIZE 19004L
#define FUNC_LOCAL_ADDR_EXP 19005L
#define FUNC_LOCAL_FLAGS 19006L
#define FUNC_LOCAL_NAME 19007L
#define FUNC_EFFECT_ID 20001L
#define FUNC_EFFECT_FUNC 20002L
#define FUNC_EFFECT_LOC 20003L
#define FUNC_EFFECT_TYPE 20004L
#define FUNC_EFFECT_CHANGE 20005L
#define FUNC_EFFECT_AMOUNT 20006L
#define F_INLINE_ID 21001L
#define F_INLINE_NAME 21002L
#define F_INLINE_RVA 21003L
#define F_INLINE_SIZE 21004L
#define F_INLINE_TAG 21005L
#define STRUCTURE_ID 22001L
#define STRUCTURE_NAME 22002L
#define STRUCTURE_SIZE 22003L
#define STRUCT_MEMBER_ID 23001L
#define STRUCT_MEMBER_TYPE 23002L
#define STRUCT_MEMBER_SIZE 23003L
#define STRUCT_MEMBER_STRUCTURE 23004L
#define STRUCT_MEMBER_ORDER 23005L
#define STRUCT_MEMBER_NAME 23006L
#define STRUCT_MEMBER_CONST_GROUP 23007L
#define DATA_TYPE_ID 24001L
#define DATA_TYPE_SIZE 24002L
#define DATA_TYPE_FLAGS 24003L
#define DATA_TYPE_NAME 24004L
#define CONSTANT_ID 25001L
#define CONSTANT_NAME 25002L
#define VALUE 25003L
#define GROUP 25004L
#define CONSTANT_GROUP_ID 26001L
#define CONSTANT_GROUP_NAME 26002L
#define BC_MACRO_ID 27001L
#define BC_MACRO_TYPE 27002L
#define BC_MACRO_NAME 27003L
#define MACRO 27004L

/*---------- key names ----------*/
#define XREF_FROM_RVA 7
#define XREF_TO_RVA 8
#define CODE_FUNCTION 10
#define CODE_DEST_OP 11
#define CODE_SRC_OP 12
#define CODE_MNEMONIC 13
#define CODE_EFFECT_RVAID 16
#define REG_STATE_BY_REF 18
#define SYSREF_TYPE_ID 20
#define SYSREF_FROM 21
#define FN_ORDER 24
#define IMPORT_LIBRARY 29
#define FUNC_PARAM_FUNCID 40
#define FUNC_LOCAL_FUNCID 42
#define FUNC_EFFECT_FUNCID 44
#define STRUCT_MEMBER_STRUCT 49
#define CONSTANT_GROUP_VALUE 55

/*---------- sequence names ----------*/

/*---------- integer constants ----------*/
#endif 
