/*  B A S T A R D    A P I  :  */
/*  */

#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */
/* SECTION types and permissions */
#define SECTION_HDR      0x1000
#define SECTION_CODE   0x1100
#define SECTION_DATA   0x1200
#define SECTION_RSRC   0x1300
#define SECTION_IMPORT   0x1400
#define SECTION_EXPORT   0x1500
#define SECTION_DEBUG   0x1600
#define SECTION_CMT      0x1700
#define SECTION_RELOC   0x1800
#define SECTION_EXECUTE   0x01
#define SECTION_WRITE   0x02
#define SECTION_READ   0x04
#define SECTION_TYPE_MASK 0xFF00
#define SECTION_PERM_MASK 0x000F
/*   sec_new:  Create a program section or segment
 *    Return Value:   1 = success, 0 = error
 *     Arguments:      char *name -- name of section [must be unique]
 *                    long start -- starting rva of section 
 *                    long pa    -- starting physical addr of section
 *                    int  size  -- size of section, in bytes
 *                    int  type  -- section type ORed with permissions : 
   types : SECTION_HDR   SECTION_CODE SECTION_DATA SECTION_RSRC SECTION_RELOC
           SECTION_IMPORT SECTION_EXPORT SECTION_DEBUG SECTION_CMT   
   perms : SECTION_EXECUTE SECTION_WRITE   SECTION_READ           */
int sec_new( char *name, long start, int size, long pa, int type );
/*   sec_del: Delete a program section [be careful!]
 *    Return Value:   1 = success, 0 = error
 *     Arguments:      char *name -- name of section to delete  */
int sec_del( char *name );
/*   sec_get: Finds the Section that contains a given addr
 *    Return Value: 1 if found, 0 if not
 *    Arguments:    long rva   -- known address
 *                  section *s -- empty structure to fill w/ found section */
int sec_get( long rva, struct section *s);
/*   sec_get_start: Get starting address of a given section
 *    Return Value: rva of start of section, 0 if not found   
 *     Arguments:     char *name -- name of section to get the start of    */
    /* FIX: should increase the end addr of the prev section thru curr->end */
long sec_get_start( char *name );
/*   sec_get_end: Get address of the last byte in a given section
 *    Return Value: rva of end of section [not last ADDRESS in section!] or 0   
 *     Arguments:     char *name -- name of section to get the end of    */
long sec_get_end( char *name );
/*   sec_get_by_rva: Get name of section
 *    Return Value:   1 if found, 0 if not
 *     Arguments:      long rva     -- address within section 
 *                    char buf[32] -- buffer to fill with section name */
int  sec_get_by_rva( long rva, char* buf );
/*   sec_flags: Get section type/permissions 
 *    Return Value:   Type and permissions OR'ed together
 *     Arguments:      char *name -- name of section to get the flags of */
int  sec_flags( char *name );
/*   sec_set_start:  Set the starting address of a section
 *    Return Value:     1 if success, 0 if error
 *     Arguments:        char *name -- name of section
 *                      long start -- new starting rva of section */
int  sec_set_start( char *name, long start );
/*   sec_get_end: Set the ending address of a section
 *    Return Value:   1 if success, 0 if error
 *     Arguments:      char *name -- name of section
 *                    long end   -- rva of the "new" last byte in the section */
int  sec_set_end( char *name, long end );
/*   sec_rename: Set the name of a section
 *    Return Value:   1 if success, 0 if error
 *     Arguments:      char *name == old name, char *new_name = new name */
int  sec_rename( char *name, char *new_name );
/*   sec_set_flags: Change the type/permissions of a section
 *    Return Value:   1 id success, 0 if failure
 *     Arguments:      char *name -- name of section
 *                    int  flags -- new type and permissions ORed together */
int  sec_set_flags( char *name, int flags );
int  sec_foreach( BAPI_CALLBACK fn, void *arg );
int  sec_foreach_addr( struct section *s, BAPI_CALLBACK fn, void *arg );


/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
